/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.quickfixj;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.util.ObjectHelper;
import quickfix.Field;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Message;
import quickfix.SessionID;

public class MessagePredicate {
    private final List<Field<String>> headerCriteria = new ArrayList<Field<String>>();
    private final List<Field<String>> bodyCriteria = new ArrayList<Field<String>>();

    public MessagePredicate(SessionID requestingSessionID, String msgType) {
        this.addHeaderFieldIfPresent(49, requestingSessionID.getSenderCompID());
        this.addHeaderFieldIfPresent(56, requestingSessionID.getTargetCompID());
        this.withMessageType(msgType);
    }

    private void addHeaderFieldIfPresent(int tag, String value) {
        if (!ObjectHelper.isEmpty(value)) {
            this.withHeaderField(tag, value);
        }
    }

    public boolean evaluate(Message message) {
        return this.evaluate(message, this.bodyCriteria) && this.evaluate(message.getHeader(), this.headerCriteria);
    }

    private boolean evaluate(FieldMap fieldMap, List<Field<String>> criteria) {
        for (Field<String> c : criteria) {
            String value = null;
            try {
                if (fieldMap.isSetField(c.getField())) {
                    value = fieldMap.getString(c.getField());
                }
            }
            catch (FieldNotFound e) {
                throw RuntimeCamelException.wrapRuntimeCamelException(e);
            }
            if (c.getObject().equals(value)) continue;
            return false;
        }
        return true;
    }

    public MessagePredicate withField(int tag, String value) {
        this.bodyCriteria.add(new Field<String>(tag, value));
        return this;
    }

    public MessagePredicate withHeaderField(int tag, String value) {
        this.headerCriteria.add(new Field<String>(tag, value));
        return this;
    }

    private MessagePredicate withMessageType(String msgType) {
        this.headerCriteria.add(new Field<String>(35, msgType));
        return this;
    }
}

