/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.remote;

import io.netty.util.Timeout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.redisson.RedissonBlockingQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RemoteInvocationOptions;
import org.redisson.client.codec.Codec;
import org.redisson.client.codec.LongCodec;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.command.CommandAsyncExecutor;
import org.redisson.remote.BaseRemoteService;
import org.redisson.remote.RRemoteServiceResponse;
import org.redisson.remote.RemoteServiceAck;
import org.redisson.remote.RemoteServiceTimeoutException;
import org.redisson.remote.ResponseEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRemoteProxy {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    final CommandAsyncExecutor commandExecutor;
    private final String name;
    final String responseQueueName;
    private final Map<String, ResponseEntry> responses;
    final Codec codec;
    final String executorId;
    final BaseRemoteService remoteService;
    private final Map<Class<?>, String> requestQueueNameCache = new ConcurrentHashMap();

    BaseRemoteProxy(CommandAsyncExecutor commandExecutor, String name, String responseQueueName, Codec codec, String executorId, BaseRemoteService remoteService) {
        this.commandExecutor = commandExecutor;
        this.name = name;
        this.responseQueueName = responseQueueName;
        this.responses = commandExecutor.getServiceManager().getResponses();
        this.codec = codec;
        this.executorId = executorId;
        this.remoteService = remoteService;
    }

    public String getRequestQueueName(Class<?> remoteInterface) {
        return this.requestQueueNameCache.computeIfAbsent(remoteInterface, k -> "{" + this.name + ":" + k.getName() + "}");
    }

    protected CompletionStage<RemoteServiceAck> tryPollAckAgainAsync(RemoteInvocationOptions optionsCopy, String ackName, String requestId) {
        RFuture ackClientsFuture = this.commandExecutor.evalWriteNoRetryAsync(ackName, LongCodec.INSTANCE, RedisCommands.EVAL_BOOLEAN, "if redis.call('setnx', KEYS[1], 1) == 1 then redis.call('pexpire', KEYS[1], ARGV[1]);return 0;end;redis.call('del', KEYS[1]);return 1;", Arrays.asList(ackName), optionsCopy.getAckTimeoutInMillis());
        return ackClientsFuture.thenCompose(res -> {
            if (res.booleanValue()) {
                return this.pollResponse(this.commandExecutor.getServiceManager().getConfig().getTimeout(), requestId, true);
            }
            return CompletableFuture.completedFuture(null);
        });
    }

    protected final <T extends RRemoteServiceResponse> CompletableFuture<T> pollResponse(long timeout, String requestId, boolean insertFirst) {
        CompletableFuture responseFuture = new CompletableFuture();
        ResponseEntry e = this.responses.compute(this.responseQueueName, (key, entry) -> {
            if (entry == null) {
                entry = new ResponseEntry();
            }
            this.addCancelHandling(requestId, responseFuture);
            Timeout responseTimeoutFuture = this.createResponseTimeout(timeout, requestId, responseFuture);
            Map<String, List<ResponseEntry.Result>> entryResponses = entry.getResponses();
            List list = entryResponses.computeIfAbsent(requestId, k -> new ArrayList(3));
            ResponseEntry.Result res = new ResponseEntry.Result(responseFuture, responseTimeoutFuture);
            if (insertFirst) {
                list.add(0, res);
            } else {
                list.add(res);
            }
            return entry;
        });
        if (e.getStarted().compareAndSet(false, true)) {
            this.pollResponse();
        }
        return responseFuture;
    }

    private <T extends RRemoteServiceResponse> Timeout createResponseTimeout(long timeout, String requestId, CompletableFuture<T> responseFuture) {
        return this.commandExecutor.getServiceManager().newTimeout(t -> this.responses.computeIfPresent(this.responseQueueName, (k, entry) -> {
            RemoteServiceTimeoutException ex = new RemoteServiceTimeoutException("No response after " + timeout + "ms");
            if (!responseFuture.completeExceptionally(ex)) {
                return entry;
            }
            List<ResponseEntry.Result> list = entry.getResponses().get(requestId);
            list.remove(0);
            if (list.isEmpty()) {
                entry.getResponses().remove(requestId);
            }
            if (entry.getResponses().isEmpty()) {
                return null;
            }
            return entry;
        }), timeout, TimeUnit.MILLISECONDS);
    }

    private <T extends RRemoteServiceResponse> void addCancelHandling(String requestId, CompletableFuture<T> responseFuture) {
        responseFuture.whenComplete((res, ex) -> {
            if (!responseFuture.isCancelled()) {
                return;
            }
            this.responses.computeIfPresent(this.responseQueueName, (key, e) -> {
                List<ResponseEntry.Result> list = e.getResponses().get(requestId);
                if (list == null) {
                    return e;
                }
                Iterator<ResponseEntry.Result> iterator = list.iterator();
                while (iterator.hasNext()) {
                    ResponseEntry.Result result = iterator.next();
                    if (result.getPromise() != responseFuture) continue;
                    result.cancelResponseTimeout();
                    iterator.remove();
                }
                if (list.isEmpty()) {
                    e.getResponses().remove(requestId);
                }
                if (e.getResponses().isEmpty()) {
                    return null;
                }
                return e;
            });
        });
    }

    private void pollResponse() {
        RedissonBlockingQueue queue = new RedissonBlockingQueue(this.codec, this.commandExecutor, this.responseQueueName);
        RFuture future = queue.pollAsync(60L, TimeUnit.SECONDS);
        future.whenComplete(this.createResponseListener());
    }

    private BiConsumer<RRemoteServiceResponse, Throwable> createResponseListener() {
        return (response, e) -> {
            if (e != null) {
                if (this.commandExecutor.getServiceManager().isShuttingDown((Throwable)e)) {
                    return;
                }
                this.log.error("Can't get response from {}. Try to increase 'retryInterval' and/or 'retryAttempts' settings", (Object)this.responseQueueName, e);
                return;
            }
            if (response == null) {
                this.pollResponse();
                return;
            }
            AtomicReference future = new AtomicReference();
            this.responses.computeIfPresent(this.responseQueueName, (k, entry) -> {
                String key = response.getId();
                List<ResponseEntry.Result> list = entry.getResponses().get(key);
                if (list == null) {
                    this.pollResponse();
                    return null;
                }
                ResponseEntry.Result res = list.remove(0);
                if (list.isEmpty()) {
                    entry.getResponses().remove(key);
                }
                CompletableFuture f = res.getPromise();
                res.cancelResponseTimeout();
                future.set(f);
                if (entry.getResponses().isEmpty()) {
                    return null;
                }
                this.pollResponse();
                return entry;
            });
            if (future.get() != null) {
                ((CompletableFuture)future.get()).complete(response);
            }
        };
    }
}

