/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.resilience4j;

import io.github.resilience4j.bulkhead.BulkheadConfig;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import io.github.resilience4j.timelimiter.TimeLimiterConfig;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.component.resilience4j.ResilienceProcessor;
import org.apache.camel.model.CircuitBreakerDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.Resilience4jConfigurationCommon;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.reifier.ProcessorReifier;
import org.apache.camel.spi.BeanIntrospection;
import org.apache.camel.spi.ExtendedPropertyConfigurerGetter;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PluginHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.util.function.Suppliers;

public class ResilienceReifier
extends ProcessorReifier<CircuitBreakerDefinition> {
    public ResilienceReifier(Route route, CircuitBreakerDefinition definition) {
        super(route, definition);
    }

    @Override
    public Processor createProcessor() throws Exception {
        boolean fallbackViaNetwork;
        Processor processor = this.createChildProcessor(true);
        Processor fallback = null;
        if (((CircuitBreakerDefinition)this.definition).getOnFallback() != null) {
            fallback = this.createProcessor(((CircuitBreakerDefinition)this.definition).getOnFallback());
        }
        boolean bl = fallbackViaNetwork = ((CircuitBreakerDefinition)this.definition).getOnFallback() != null && this.parseBoolean(((CircuitBreakerDefinition)this.definition).getOnFallback().getFallbackViaNetwork(), false);
        if (fallbackViaNetwork) {
            throw new UnsupportedOperationException("camel-resilience4j does not support onFallbackViaNetwork");
        }
        Resilience4jConfigurationDefinition config = this.buildResilience4jConfiguration();
        CircuitBreakerConfig cbConfig = this.configureCircuitBreaker(config);
        BulkheadConfig bhConfig = this.configureBulkHead(config);
        TimeLimiterConfig tlConfig = this.configureTimeLimiter(config);
        boolean throwExceptionWhenHalfOpenOrOpenState = false;
        Boolean b = CamelContextHelper.parseBoolean(this.camelContext, config.getThrowExceptionWhenHalfOpenOrOpenState());
        if (b != null) {
            throwExceptionWhenHalfOpenOrOpenState = b;
        }
        ResilienceProcessor answer = new ResilienceProcessor(cbConfig, bhConfig, tlConfig, processor, fallback, throwExceptionWhenHalfOpenOrOpenState);
        this.configureTimeoutExecutorService(answer, config);
        if (config.getCircuitBreaker() != null) {
            CircuitBreaker cb = this.mandatoryLookup(this.parseString(config.getCircuitBreaker()), CircuitBreaker.class);
            answer.setCircuitBreaker(cb);
        }
        return answer;
    }

    private CircuitBreakerConfig configureCircuitBreaker(Resilience4jConfigurationCommon config) throws ClassNotFoundException {
        CircuitBreakerConfig.Builder builder = CircuitBreakerConfig.custom();
        if (config.getAutomaticTransitionFromOpenToHalfOpenEnabled() != null) {
            builder.automaticTransitionFromOpenToHalfOpenEnabled(this.parseBoolean(config.getAutomaticTransitionFromOpenToHalfOpenEnabled()));
        }
        if (config.getFailureRateThreshold() != null) {
            builder.failureRateThreshold(this.parseFloat(config.getFailureRateThreshold()).floatValue());
        }
        if (config.getMinimumNumberOfCalls() != null) {
            builder.minimumNumberOfCalls(this.parseInt(config.getMinimumNumberOfCalls()));
        }
        if (config.getPermittedNumberOfCallsInHalfOpenState() != null) {
            builder.permittedNumberOfCallsInHalfOpenState(this.parseInt(config.getPermittedNumberOfCallsInHalfOpenState()));
        }
        if (config.getSlidingWindowSize() != null) {
            builder.slidingWindowSize(this.parseInt(config.getSlidingWindowSize()));
        }
        if (config.getSlidingWindowType() != null) {
            builder.slidingWindowType(CircuitBreakerConfig.SlidingWindowType.valueOf(config.getSlidingWindowType()));
        }
        if (config.getSlowCallDurationThreshold() != null) {
            builder.slowCallDurationThreshold(Duration.ofSeconds(this.parseLong(config.getSlowCallDurationThreshold())));
        }
        if (config.getSlowCallRateThreshold() != null) {
            builder.slowCallRateThreshold(this.parseFloat(config.getSlowCallRateThreshold()).floatValue());
        }
        if (config.getWaitDurationInOpenState() != null) {
            builder.waitDurationInOpenState(Duration.ofSeconds(this.parseLong(config.getWaitDurationInOpenState())));
        }
        if (config.getWritableStackTraceEnabled() != null) {
            builder.writableStackTraceEnabled(this.parseBoolean(config.getWritableStackTraceEnabled()));
        }
        if (config.getRecordExceptions() != null) {
            builder.ignoreExceptions(this.createRecordExceptionClasses());
        }
        if (config.getIgnoreExceptions() != null) {
            builder.ignoreExceptions(this.createIgnoreExceptionClasses());
        }
        return builder.build();
    }

    private BulkheadConfig configureBulkHead(Resilience4jConfigurationCommon config) {
        if (!this.parseBoolean(config.getBulkheadEnabled(), false)) {
            return null;
        }
        BulkheadConfig.Builder builder = BulkheadConfig.custom();
        if (config.getBulkheadMaxConcurrentCalls() != null) {
            builder.maxConcurrentCalls(this.parseInt(config.getBulkheadMaxConcurrentCalls()));
        }
        if (config.getBulkheadMaxWaitDuration() != null) {
            long duration = this.parseLong(config.getBulkheadMaxWaitDuration());
            if (duration <= 0L) {
                builder.maxWaitDuration(Duration.ZERO);
            } else {
                builder.maxWaitDuration(Duration.ofMillis(duration));
            }
        }
        return builder.build();
    }

    private TimeLimiterConfig configureTimeLimiter(Resilience4jConfigurationCommon config) {
        if (!this.parseBoolean(config.getTimeoutEnabled(), false)) {
            return null;
        }
        TimeLimiterConfig.Builder builder = TimeLimiterConfig.custom();
        if (config.getTimeoutDuration() != null) {
            builder.timeoutDuration(Duration.ofMillis(this.parseLong(config.getTimeoutDuration())));
        }
        if (config.getTimeoutCancelRunningFuture() != null) {
            builder.cancelRunningFuture(this.parseBoolean(config.getTimeoutCancelRunningFuture()));
        }
        return builder.build();
    }

    private void configureTimeoutExecutorService(ResilienceProcessor processor, Resilience4jConfigurationCommon config) {
        if (!this.parseBoolean(config.getTimeoutEnabled(), false)) {
            return;
        }
        if (config.getTimeoutExecutorService() != null) {
            String ref = config.getTimeoutExecutorService();
            boolean shutdownThreadPool = false;
            ExecutorService executorService = this.lookupByNameAndType(ref, ExecutorService.class);
            if (executorService == null) {
                executorService = this.lookupExecutorServiceRef("CircuitBreaker", this.definition, ref);
                shutdownThreadPool = true;
            }
            processor.setExecutorService(executorService);
            processor.setShutdownExecutorService(shutdownThreadPool);
        }
    }

    Resilience4jConfigurationDefinition buildResilience4jConfiguration() throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        PropertyConfigurer configurer = PluginHelper.getConfigurerResolver(this.camelContext).resolvePropertyConfigurer(Resilience4jConfigurationDefinition.class.getName(), this.camelContext);
        this.loadProperties(properties, Suppliers.firstNotNull(() -> this.camelContext.getCamelContextExtension().getContextPlugin(Model.class).getResilience4jConfiguration(null), () -> this.lookupByNameAndType("resilience4j-configuration", Resilience4jConfigurationDefinition.class)), configurer);
        if (((CircuitBreakerDefinition)this.definition).getConfiguration() != null) {
            String ref = this.parseString(((CircuitBreakerDefinition)this.definition).getConfiguration());
            this.loadProperties(properties, Suppliers.firstNotNull(() -> this.camelContext.getCamelContextExtension().getContextPlugin(Model.class).getResilience4jConfiguration(ref), () -> this.mandatoryLookup(ref, Resilience4jConfigurationDefinition.class)), configurer);
        }
        this.loadProperties(properties, Optional.ofNullable(((CircuitBreakerDefinition)this.definition).getResilience4jConfiguration()), configurer);
        Resilience4jConfigurationDefinition config = new Resilience4jConfigurationDefinition();
        PropertyBindingSupport.build().withCamelContext(this.camelContext).withIgnoreCase(true).withConfigurer(configurer).withProperties(properties).withTarget(config).bind();
        return config;
    }

    private void loadProperties(Map<String, Object> properties, Optional<?> optional, PropertyConfigurer configurer) {
        BeanIntrospection beanIntrospection = PluginHelper.getBeanIntrospection(this.camelContext);
        optional.ifPresent(bean -> {
            if (configurer instanceof ExtendedPropertyConfigurerGetter) {
                ExtendedPropertyConfigurerGetter getter = (ExtendedPropertyConfigurerGetter)((Object)configurer);
                Map<String, Object> types = getter.getAllOptions(bean);
                types.forEach((k, t) -> {
                    Object value = getter.getOptionValue(bean, (String)k, true);
                    if (value != null) {
                        properties.put((String)k, value);
                    }
                });
            } else {
                beanIntrospection.getProperties(bean, properties, null, false);
            }
        });
    }

    private Class<? extends Throwable>[] createRecordExceptionClasses() throws ClassNotFoundException {
        return this.resolveExceptions(((CircuitBreakerDefinition)this.definition).resilience4jConfiguration().getRecordExceptions());
    }

    private Class<? extends Throwable>[] createIgnoreExceptionClasses() throws ClassNotFoundException {
        return this.resolveExceptions(((CircuitBreakerDefinition)this.definition).resilience4jConfiguration().getIgnoreExceptions());
    }

    private Class<? extends Throwable>[] resolveExceptions(List<String> list) throws ClassNotFoundException {
        ArrayList<Class<Throwable>> answer = new ArrayList<Class<Throwable>>(list.size());
        for (String name : list) {
            Class<Throwable> type = this.camelContext.getClassResolver().resolveMandatoryClass(name, Throwable.class);
            answer.add(type);
        }
        return answer.toArray(new Class[0]);
    }
}

