/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.resequencer;

import java.util.Comparator;
import java.util.Objects;
import java.util.TreeSet;
import org.apache.camel.processor.resequencer.SequenceElementComparator;

public class Sequence<E>
extends TreeSet<E> {
    private static final long serialVersionUID = 5647393631147741711L;

    public Sequence(SequenceElementComparator<E> comparator) {
        super((Comparator)Objects.requireNonNull(comparator));
    }

    public E predecessor(E e) {
        E elem = this.lower(e);
        if (elem == null) {
            return null;
        }
        if (this.seqComparator().predecessor(elem, e)) {
            return elem;
        }
        return null;
    }

    public E successor(E e) {
        E elem = this.higher(e);
        if (elem == null) {
            return null;
        }
        if (this.seqComparator().successor(elem, e)) {
            return elem;
        }
        return null;
    }

    public SequenceElementComparator<E> seqComparator() {
        return Objects.requireNonNull((SequenceElementComparator)super.comparator());
    }

    @Override
    public E higher(E e) {
        boolean found = false;
        for (Object current : this) {
            if (found) {
                return current;
            }
            if (this.seqComparator().compare(e, current) != 0) continue;
            found = true;
        }
        return null;
    }

    @Override
    public E lower(E e) {
        E last = null;
        for (Object current : this) {
            if (this.seqComparator().compare(e, current) == 0) {
                return last;
            }
            last = current;
        }
        return last;
    }
}

