/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathFilter;
import com.alibaba.fastjson2.JSONPathFunction;
import com.alibaba.fastjson2.JSONPathMulti;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONPathSegmentIndex;
import com.alibaba.fastjson2.JSONPathSegmentName;
import com.alibaba.fastjson2.JSONPathSingle;
import com.alibaba.fastjson2.JSONPathSingleIndex;
import com.alibaba.fastjson2.JSONPathSingleName;
import com.alibaba.fastjson2.JSONPathTwoSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;

class JSONPathParser {
    final String path;
    final JSONReader jsonReader;
    boolean dollar;
    boolean lax;
    boolean strict;
    int segmentIndex;
    JSONPathSegment first;
    JSONPathSegment second;
    List<JSONPathSegment> segments;
    int filterNests;
    boolean negative;

    public JSONPathParser(String str) {
        this.path = str;
        this.jsonReader = JSONReader.of(this.path, JSONPath.PARSE_CONTEXT);
        if (this.jsonReader.ch == 'l' && this.jsonReader.nextIfMatchIdent('l', 'a', 'x')) {
            this.lax = true;
        } else if (this.jsonReader.ch == 's' && this.jsonReader.nextIfMatchIdent('s', 't', 'r', 'i', 'c', 't')) {
            this.strict = true;
        }
        if (this.jsonReader.ch == '-') {
            this.jsonReader.next();
            this.negative = true;
        }
        if (this.jsonReader.ch == '$') {
            this.jsonReader.next();
            this.dollar = true;
        }
    }

    JSONPath parse(JSONPath.Feature ... features) {
        if (this.dollar && this.jsonReader.ch == '\u001a') {
            if (this.negative) {
                return new JSONPathSingle(JSONPathFunction.FUNC_NEGATIVE, this.path, new JSONPath.Feature[0]);
            }
            return JSONPath.RootPath.INSTANCE;
        }
        if (this.jsonReader.ch == 'e' && this.jsonReader.nextIfMatchIdent('e', 'x', 'i', 's', 't', 's')) {
            char ch;
            if (!this.jsonReader.nextIfMatch('(')) {
                throw new JSONException("syntax error " + this.path);
            }
            if (this.jsonReader.ch == '@') {
                this.jsonReader.next();
                if (!this.jsonReader.nextIfMatch('.')) {
                    throw new JSONException("syntax error " + this.path);
                }
            }
            if (!((ch = this.jsonReader.ch) >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_' || ch == '@')) {
                throw new JSONException("syntax error " + this.path);
            }
            JSONPathSegment segment = this.parseProperty();
            if (!this.jsonReader.nextIfMatch(')')) {
                throw new JSONException("syntax error " + this.path);
            }
            return new JSONPathTwoSegment(this.path, segment, JSONPathFunction.FUNC_EXISTS, new JSONPath.Feature[0]);
        }
        while (this.jsonReader.ch != '\u001a') {
            JSONPathSegment segment;
            char ch = this.jsonReader.ch;
            if (ch == '.') {
                this.jsonReader.next();
                segment = this.parseProperty();
            } else if (this.jsonReader.ch == '[') {
                segment = this.parseArrayAccess();
            } else if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch == '_') {
                segment = this.parseProperty();
            } else if (ch == '?') {
                if (this.dollar && this.segmentIndex == 0) {
                    this.first = JSONPathSegment.RootSegment.INSTANCE;
                    ++this.segmentIndex;
                }
                this.jsonReader.next();
                segment = this.parseFilter();
            } else if (ch == '@') {
                this.jsonReader.next();
                segment = JSONPathSegment.SelfSegment.INSTANCE;
            } else {
                throw new JSONException("not support " + ch);
            }
            if (this.segmentIndex == 0) {
                this.first = segment;
            } else if (this.segmentIndex == 1) {
                this.second = segment;
            } else if (this.segmentIndex == 2) {
                this.segments = new ArrayList<JSONPathSegment>();
                this.segments.add(this.first);
                this.segments.add(this.second);
                this.segments.add(segment);
            } else {
                this.segments.add(segment);
            }
            ++this.segmentIndex;
        }
        if (this.negative) {
            if (this.segmentIndex == 1) {
                this.second = JSONPathFunction.FUNC_NEGATIVE;
            } else if (this.segmentIndex == 2) {
                this.segments = new ArrayList<JSONPathSegment>();
                this.segments.add(this.first);
                this.segments.add(this.second);
                this.segments.add(JSONPathFunction.FUNC_NEGATIVE);
            } else {
                this.segments.add(JSONPathFunction.FUNC_NEGATIVE);
            }
            ++this.segmentIndex;
        }
        if (this.segmentIndex == 1) {
            if (this.first instanceof JSONPathSegmentName) {
                return new JSONPathSingleName(this.path, (JSONPathSegmentName)this.first, features);
            }
            if (this.first instanceof JSONPathSegmentIndex) {
                JSONPathSegmentIndex firstIndex = (JSONPathSegmentIndex)this.first;
                if (firstIndex.index >= 0) {
                    return new JSONPathSingleIndex(this.path, firstIndex, features);
                }
            }
            return new JSONPathSingle(this.first, this.path, features);
        }
        if (this.segmentIndex == 2) {
            return new JSONPathTwoSegment(this.path, this.first, this.second, features);
        }
        return new JSONPathMulti(this.path, this.segments, features);
    }

    private JSONPathSegment parseArrayAccess() {
        JSONPathSegment segment;
        this.jsonReader.next();
        block0 : switch (this.jsonReader.ch) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                int index = this.jsonReader.readInt32Value();
                boolean last = false;
                if (this.jsonReader.ch == ':') {
                    this.jsonReader.next();
                    if (this.jsonReader.ch == ']') {
                        segment = new JSONPathSegment.RangeIndexSegment(index, index >= 0 ? Integer.MAX_VALUE : 0);
                        break;
                    }
                    int end = this.jsonReader.readInt32Value();
                    segment = new JSONPathSegment.RangeIndexSegment(index, end);
                    break;
                }
                if (this.jsonReader.isNumber() || (last = this.jsonReader.nextIfMatchIdent('l', 'a', 's', 't'))) {
                    ArrayList<Integer> list = new ArrayList<Integer>();
                    list.add(index);
                    if (last) {
                        list.add(-1);
                        this.jsonReader.nextIfComma();
                    }
                    while (true) {
                        if (this.jsonReader.isNumber()) {
                            index = this.jsonReader.readInt32Value();
                            list.add(index);
                            continue;
                        }
                        if (!this.jsonReader.nextIfMatchIdent('l', 'a', 's', 't')) break;
                        list.add(-1);
                        this.jsonReader.nextIfComma();
                    }
                    int[] indics = new int[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        indics[i] = (Integer)list.get(i);
                    }
                    segment = new JSONPathSegment.MultiIndexSegment(indics);
                    break;
                }
                segment = JSONPathSegmentIndex.of(index);
                break;
            }
            case '*': {
                this.jsonReader.next();
                segment = JSONPathSegment.AllSegment.INSTANCE_ARRAY;
                break;
            }
            case ':': {
                int end;
                this.jsonReader.next();
                int n = end = this.jsonReader.ch == ']' ? 0 : this.jsonReader.readInt32Value();
                if (end > 0) {
                    segment = new JSONPathSegment.RangeIndexSegment(0, end);
                    break;
                }
                segment = new JSONPathSegment.RangeIndexSegment(Integer.MIN_VALUE, end);
                break;
            }
            case '\"': 
            case '\'': {
                String name = this.jsonReader.readString();
                if (this.jsonReader.current() == ']') {
                    segment = new JSONPathSegmentName(name, Fnv.hashCode64(name));
                    break;
                }
                if (this.jsonReader.isString()) {
                    ArrayList<String> names = new ArrayList<String>();
                    names.add(name);
                    do {
                        names.add(this.jsonReader.readString());
                    } while (this.jsonReader.isString());
                    String[] nameArray = new String[names.size()];
                    names.toArray(nameArray);
                    segment = new JSONPathSegment.MultiNameSegment(nameArray);
                    break;
                }
                throw new JSONException("TODO : " + this.jsonReader.current());
            }
            case '?': {
                this.jsonReader.next();
                segment = this.parseFilter();
                break;
            }
            case 'r': {
                String fieldName = this.jsonReader.readFieldNameUnquote();
                if ("randomIndex".equals(fieldName) && this.jsonReader.nextIfMatch('(') && this.jsonReader.nextIfMatch(')') && this.jsonReader.ch == ']') {
                    segment = JSONPathSegment.RandomIndexSegment.INSTANCE;
                    break;
                }
                throw new JSONException("not support : " + fieldName);
            }
            case 'l': {
                String fieldName = this.jsonReader.readFieldNameUnquote();
                if ("last".equals(fieldName)) {
                    segment = JSONPathSegmentIndex.of(-1);
                    break;
                }
                throw new JSONException("not support : " + fieldName);
            }
            case '(': {
                this.jsonReader.next();
                if (this.jsonReader.nextIfMatch('@') && this.jsonReader.nextIfMatch('.')) {
                    String fieldName;
                    switch (fieldName = this.jsonReader.readFieldNameUnquote()) {
                        case "length": 
                        case "size": {
                            int index = this.jsonReader.readInt32Value();
                            if (!this.jsonReader.nextIfMatch(')')) {
                                throw new JSONException("not support : " + fieldName);
                            }
                            if (index > 0) {
                                throw new JSONException("not support : " + fieldName);
                            }
                            segment = JSONPathSegmentIndex.of(index);
                            break block0;
                        }
                    }
                    throw new JSONException("not support : " + this.path);
                }
                throw new JSONException("not support : " + this.path);
            }
            default: {
                throw new JSONException("TODO : " + this.jsonReader.current());
            }
        }
        if (this.jsonReader.ch == '&' || this.jsonReader.ch == '|' || this.jsonReader.ch == 'a' || this.jsonReader.ch == 'o') {
            --this.filterNests;
            segment = this.parseFilterRest(segment);
        }
        while (this.filterNests > 0) {
            this.jsonReader.next();
            --this.filterNests;
        }
        if (!this.jsonReader.nextIfArrayEnd()) {
            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
        }
        return segment;
    }

    private JSONPathSegment parseProperty() {
        JSONPathSegment segment;
        if (this.jsonReader.ch == '*') {
            this.jsonReader.next();
            segment = JSONPathSegment.AllSegment.INSTANCE;
        } else if (this.jsonReader.ch == '.') {
            this.jsonReader.next();
            if (this.jsonReader.ch == '*') {
                this.jsonReader.next();
                segment = new JSONPathSegment.CycleNameSegment("*", Fnv.hashCode64("*"));
            } else {
                long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
                String name = this.jsonReader.getFieldName();
                segment = new JSONPathSegment.CycleNameSegment(name, hashCode);
            }
        } else {
            int length;
            boolean isNum = this.jsonReader.isNumber();
            long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
            String name = this.jsonReader.getFieldName();
            if (isNum && (length = name.length()) <= 9) {
                char ch;
                for (int i = 0; i < length && (ch = name.charAt(i)) >= '0' && ch <= '9'; ++i) {
                }
            }
            if (this.jsonReader.ch == '(') {
                this.jsonReader.next();
                switch (name) {
                    case "length": 
                    case "size": {
                        segment = JSONPathSegment.LengthSegment.INSTANCE;
                        break;
                    }
                    case "keys": {
                        segment = JSONPathSegment.KeysSegment.INSTANCE;
                        break;
                    }
                    case "values": {
                        segment = JSONPathSegment.ValuesSegment.INSTANCE;
                        break;
                    }
                    case "entrySet": {
                        segment = JSONPathSegment.EntrySetSegment.INSTANCE;
                        break;
                    }
                    case "min": {
                        segment = JSONPathSegment.MinSegment.INSTANCE;
                        break;
                    }
                    case "max": {
                        segment = JSONPathSegment.MaxSegment.INSTANCE;
                        break;
                    }
                    case "sum": {
                        segment = JSONPathSegment.SumSegment.INSTANCE;
                        break;
                    }
                    case "type": {
                        segment = JSONPathFunction.FUNC_TYPE;
                        break;
                    }
                    case "floor": {
                        segment = JSONPathFunction.FUNC_FLOOR;
                        break;
                    }
                    case "ceil": 
                    case "ceiling": {
                        segment = JSONPathFunction.FUNC_CEIL;
                        break;
                    }
                    case "double": {
                        segment = JSONPathFunction.FUNC_DOUBLE;
                        break;
                    }
                    case "abs": {
                        segment = JSONPathFunction.FUNC_ABS;
                        break;
                    }
                    case "lower": {
                        segment = JSONPathFunction.FUNC_LOWER;
                        break;
                    }
                    case "upper": {
                        segment = JSONPathFunction.FUNC_UPPER;
                        break;
                    }
                    case "trim": {
                        segment = JSONPathFunction.FUNC_TRIM;
                        break;
                    }
                    case "negative": {
                        segment = JSONPathFunction.FUNC_NEGATIVE;
                        break;
                    }
                    case "first": {
                        segment = JSONPathFunction.FUNC_FIRST;
                        break;
                    }
                    case "last": {
                        segment = JSONPathFunction.FUNC_LAST;
                        break;
                    }
                    case "index": {
                        if (this.jsonReader.isNumber()) {
                            Number number = this.jsonReader.readNumber();
                            if (number instanceof BigDecimal) {
                                BigDecimal decimal = (BigDecimal)number;
                                if ((decimal = decimal.stripTrailingZeros()).scale() != 0) {
                                    segment = new JSONPathFunction(new JSONPathFunction.IndexDecimal(decimal));
                                    break;
                                }
                                BigInteger unscaledValue = decimal.unscaledValue();
                                number = unscaledValue.compareTo(TypeUtils.BIGINT_INT64_MIN) >= 0 && unscaledValue.compareTo(TypeUtils.BIGINT_INT64_MAX) <= 0 ? Long.valueOf(unscaledValue.longValue()) : unscaledValue;
                            }
                            if (number instanceof Integer || number instanceof Long) {
                                long longValue = number.longValue();
                                segment = new JSONPathFunction(new JSONPathFunction.IndexInt(longValue));
                                break;
                            }
                        } else if (this.jsonReader.isString()) {
                            String indexValue = this.jsonReader.readString();
                            segment = new JSONPathFunction(new JSONPathFunction.IndexString(indexValue));
                            break;
                        }
                        throw new JSONException("not support syntax, path : " + this.path);
                    }
                    default: {
                        throw new JSONException("not support syntax, path : " + this.path);
                    }
                }
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException("not support syntax, path : " + this.path);
                }
            } else {
                segment = new JSONPathSegmentName(name, hashCode);
            }
        }
        return segment;
    }

    JSONPathSegment parseFilterRest(JSONPathSegment segment) {
        boolean and;
        switch (this.jsonReader.ch) {
            case '&': {
                this.jsonReader.next();
                if (!this.jsonReader.nextIfMatch('&')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                and = true;
                break;
            }
            case '|': {
                this.jsonReader.next();
                if (!this.jsonReader.nextIfMatch('|')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                and = false;
                break;
            }
            case 'A': 
            case 'a': {
                String fieldName = this.jsonReader.readFieldNameUnquote();
                if (!"and".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("syntax error : " + fieldName);
                }
                and = true;
                break;
            }
            case 'O': 
            case 'o': {
                String fieldName = this.jsonReader.readFieldNameUnquote();
                if (!"or".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("syntax error : " + fieldName);
                }
                and = false;
                break;
            }
            default: {
                throw new JSONException("TODO : " + this.jsonReader.ch);
            }
        }
        JSONPathSegment right = this.parseFilter();
        if (segment instanceof JSONPathFilter.GroupFilter) {
            JSONPathFilter.GroupFilter group = (JSONPathFilter.GroupFilter)segment;
            group.filters.add(((JSONPathFilter)right).setAnd(and));
            return group;
        }
        ArrayList<JSONPathFilter> filters = new ArrayList<JSONPathFilter>();
        filters.add((JSONPathFilter)segment);
        if (right instanceof JSONPathFilter.GroupFilter) {
            JSONPathFilter.GroupFilter group = (JSONPathFilter.GroupFilter)right;
            List<JSONPathFilter> groupFilters = group.filters;
            if (groupFilters != null && groupFilters.size() > 0) {
                for (int i = 0; i < groupFilters.size(); ++i) {
                    JSONPathFilter filter = groupFilters.get(i);
                    if (i == 0) {
                        filter.setAnd(and);
                    }
                    filters.add(filter);
                }
            }
        } else {
            filters.add(((JSONPathFilter)right).setAnd(and));
        }
        return new JSONPathFilter.GroupFilter(filters);
    }

    JSONPathSegment parseFilter() {
        JSONPathSegment segment;
        boolean ends;
        boolean at;
        boolean parentheses = this.jsonReader.nextIfMatch('(');
        if (parentheses && this.filterNests > 0) {
            ++this.filterNests;
        }
        boolean bl = at = this.jsonReader.ch == '@';
        if (at) {
            this.jsonReader.next();
        } else if (this.jsonReader.nextIfMatchIdent('e', 'x', 'i', 's', 't', 's')) {
            if (!this.jsonReader.nextIfMatch('(')) {
                throw new JSONException(this.jsonReader.info("exists"));
            }
            if (this.jsonReader.nextIfMatch('@') && this.jsonReader.nextIfMatch('.')) {
                long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = this.jsonReader.getFieldName();
                if (this.jsonReader.nextIfMatch(')')) {
                    if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                        throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                    }
                    return new JSONPathFilter.NameExistsFilter(fieldName, hashCode);
                }
            }
            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
        }
        boolean starts = this.jsonReader.nextIfMatchIdent('s', 't', 'a', 'r', 't', 's');
        boolean bl2 = ends = !starts && this.jsonReader.nextIfMatchIdent('e', 'n', 'd', 's');
        if (at && (starts || ends) || this.jsonReader.ch != '.' && !JSONReader.isFirstIdentifier(this.jsonReader.ch)) {
            JSONPathFilter.Operator operator;
            if (this.jsonReader.nextIfMatch('(')) {
                ++this.filterNests;
                ++this.filterNests;
                return this.parseFilter();
            }
            if (!at) {
                throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
            }
            if (starts || ends) {
                this.jsonReader.readFieldNameHashCodeUnquote();
                String fieldName = this.jsonReader.getFieldName();
                if (!"with".equalsIgnoreCase(fieldName)) {
                    throw new JSONException("not support operator : " + fieldName);
                }
                operator = starts ? JSONPathFilter.Operator.STARTS_WITH : JSONPathFilter.Operator.ENDS_WITH;
            } else {
                operator = JSONPath.parseOperator(this.jsonReader);
            }
            JSONPathSegment segment2 = null;
            if (this.jsonReader.isNumber()) {
                Number number = this.jsonReader.readNumber();
                if (number instanceof Integer || number instanceof Long) {
                    segment2 = new JSONPathFilter.NameIntOpSegment(null, 0L, null, null, null, operator, number.longValue());
                }
            } else if (this.jsonReader.isString()) {
                String string = this.jsonReader.readString();
                switch (operator) {
                    case STARTS_WITH: {
                        segment2 = new JSONPathFilter.StartsWithSegment(null, 0L, string);
                        break;
                    }
                    case ENDS_WITH: {
                        segment2 = new JSONPathFilter.EndsWithSegment(null, 0L, string);
                        break;
                    }
                    default: {
                        throw new JSONException("syntax error, " + string);
                    }
                }
            }
            while (this.jsonReader.ch == '&' || this.jsonReader.ch == '|') {
                --this.filterNests;
                segment2 = this.parseFilterRest(segment2);
            }
            if (segment2 != null) {
                if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                return segment2;
            }
            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
        }
        if (at) {
            this.jsonReader.next();
        }
        long hashCode = this.jsonReader.readFieldNameHashCodeUnquote();
        String fieldName = this.jsonReader.getFieldName();
        if (parentheses && this.jsonReader.nextIfMatch(')')) {
            if (this.filterNests > 0) {
                --this.filterNests;
            }
            return new JSONPathFilter.NameExistsFilter(fieldName, hashCode);
        }
        String functionName = null;
        long[] hashCode2 = null;
        String[] fieldName2 = null;
        while (this.jsonReader.ch == '.') {
            this.jsonReader.next();
            long hash = this.jsonReader.readFieldNameHashCodeUnquote();
            String str = this.jsonReader.getFieldName();
            if (this.jsonReader.ch == '(') {
                functionName = str;
                break;
            }
            if (hashCode2 == null) {
                hashCode2 = new long[]{hash};
                fieldName2 = new String[]{str};
                continue;
            }
            hashCode2 = Arrays.copyOf(hashCode2, hashCode2.length + 1);
            hashCode2[hashCode2.length - 1] = hash;
            fieldName2 = Arrays.copyOf(fieldName2, fieldName2.length + 1);
            fieldName2[fieldName2.length - 1] = str;
        }
        Enum operator = null;
        Function function = null;
        if (this.jsonReader.ch == '(') {
            if (functionName == null) {
                functionName = fieldName;
                fieldName = null;
            }
            switch (functionName) {
                case "type": {
                    hashCode = 0L;
                    function = JSONPathFunction.TypeFunction.INSTANCE;
                    break;
                }
                case "size": {
                    hashCode = 0L;
                    function = JSONPathFunction.SizeFunction.INSTANCE;
                    break;
                }
                case "contains": {
                    hashCode = 0L;
                    operator = JSONPathFilter.Operator.CONTAINS;
                    break;
                }
                default: {
                    throw new JSONException("syntax error, function not support " + fieldName);
                }
            }
            if (function != null) {
                this.jsonReader.next();
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException("syntax error, function " + functionName);
                }
            }
        }
        if (operator == null) {
            operator = JSONPath.parseOperator(this.jsonReader);
        }
        switch (1.$SwitchMap$com$alibaba$fastjson2$JSONPathFilter$Operator[operator.ordinal()]) {
            case 3: 
            case 4: 
            case 5: {
                boolean ignoreCase;
                String regex;
                if (this.jsonReader.isString()) {
                    regex = this.jsonReader.readString();
                    ignoreCase = false;
                } else {
                    regex = this.jsonReader.readPattern();
                    ignoreCase = this.jsonReader.nextIfMatch('i');
                }
                Pattern pattern = ignoreCase ? Pattern.compile(regex, 2) : Pattern.compile(regex);
                JSONPathSegment segment3 = new JSONPathFilter.NameRLikeSegment(fieldName, hashCode, pattern, operator == JSONPathFilter.Operator.NOT_RLIKE);
                if (this.jsonReader.ch == '&' || this.jsonReader.ch == '|' || this.jsonReader.ch == 'a' || this.jsonReader.ch == 'o') {
                    --this.filterNests;
                    segment3 = this.parseFilterRest(segment3);
                }
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                return segment3;
            }
            case 6: 
            case 7: {
                if (this.jsonReader.ch != '(') {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                this.jsonReader.next();
                if (this.jsonReader.isString()) {
                    ArrayList<String> list = new ArrayList<String>();
                    while (this.jsonReader.isString()) {
                        list.add(this.jsonReader.readString());
                    }
                    String[] strArray = new String[list.size()];
                    list.toArray(strArray);
                    segment = new JSONPathFilter.NameStringInSegment(fieldName, hashCode, strArray, operator == JSONPathFilter.Operator.NOT_IN);
                } else if (this.jsonReader.isNumber()) {
                    ArrayList<Number> list = new ArrayList<Number>();
                    while (this.jsonReader.isNumber()) {
                        list.add(this.jsonReader.readNumber());
                    }
                    long[] values2 = new long[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        values2[i] = ((Number)list.get(i)).longValue();
                    }
                    segment = new JSONPathFilter.NameIntInSegment(fieldName, hashCode, fieldName2, hashCode2, function, values2, operator == JSONPathFilter.Operator.NOT_IN);
                } else {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                if (this.jsonReader.ch == '&' || this.jsonReader.ch == '|' || this.jsonReader.ch == 'a' || this.jsonReader.ch == 'o') {
                    --this.filterNests;
                    segment = this.parseFilterRest(segment);
                }
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                return segment;
            }
            case 8: {
                if (this.jsonReader.ch != '(') {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                this.jsonReader.next();
                if (this.jsonReader.isString()) {
                    ArrayList<String> list = new ArrayList<String>();
                    while (this.jsonReader.isString()) {
                        list.add(this.jsonReader.readString());
                    }
                    String[] strArray = new String[list.size()];
                    list.toArray(strArray);
                    segment = new JSONPathFilter.NameStringContainsSegment(fieldName, hashCode, fieldName2, hashCode2, strArray, false);
                } else if (this.jsonReader.isNumber()) {
                    ArrayList<Number> list = new ArrayList<Number>();
                    while (this.jsonReader.isNumber()) {
                        list.add(this.jsonReader.readNumber());
                    }
                    long[] values3 = new long[list.size()];
                    for (int i = 0; i < list.size(); ++i) {
                        values3[i] = ((Number)list.get(i)).longValue();
                    }
                    segment = new JSONPathFilter.NameLongContainsSegment(fieldName, hashCode, fieldName2, hashCode2, values3, false);
                } else {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                if (!this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                return segment;
            }
            case 9: 
            case 10: {
                Number begin;
                if (this.jsonReader.isNumber()) {
                    begin = this.jsonReader.readNumber();
                    String and = this.jsonReader.readFieldNameUnquote();
                    if (!"and".equalsIgnoreCase(and)) {
                        throw new JSONException("syntax error, " + and);
                    }
                } else {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                Number end = this.jsonReader.readNumber();
                segment = new JSONPathFilter.NameIntBetweenSegment(fieldName, hashCode, begin.longValue(), end.longValue(), operator == JSONPathFilter.Operator.NOT_BETWEEN);
                if (parentheses && !this.jsonReader.nextIfMatch(')')) {
                    throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
                }
                return segment;
            }
        }
        segment = null;
        switch (this.jsonReader.ch) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                Number number = this.jsonReader.readNumber();
                if (number instanceof Integer || number instanceof Long) {
                    segment = new JSONPathFilter.NameIntOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, (JSONPathFilter.Operator)operator, number.longValue());
                    break;
                }
                if (number instanceof BigDecimal) {
                    segment = new JSONPathFilter.NameDecimalOpSegment(fieldName, hashCode, (JSONPathFilter.Operator)operator, (BigDecimal)number);
                    break;
                }
                throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
            }
            case '\"': 
            case '\'': {
                String strVal = this.jsonReader.readString();
                int p0 = strVal.indexOf(37);
                if (p0 == -1) {
                    if (operator == JSONPathFilter.Operator.LIKE) {
                        operator = JSONPathFilter.Operator.EQ;
                    } else if (operator == JSONPathFilter.Operator.NOT_LIKE) {
                        operator = JSONPathFilter.Operator.NE;
                    }
                }
                if (operator == JSONPathFilter.Operator.LIKE || operator == JSONPathFilter.Operator.NOT_LIKE) {
                    String[] items = strVal.split("%");
                    String startsWithValue = null;
                    String endsWithValue = null;
                    String[] containsValues = null;
                    if (p0 == 0) {
                        if (strVal.charAt(strVal.length() - 1) == '%') {
                            containsValues = new String[items.length - 1];
                            System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                        } else {
                            endsWithValue = items[items.length - 1];
                            if (items.length > 2) {
                                containsValues = new String[items.length - 2];
                                System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                            }
                        }
                    } else if (strVal.charAt(strVal.length() - 1) == '%') {
                        if (items.length == 1) {
                            startsWithValue = items[0];
                        } else {
                            containsValues = items;
                        }
                    } else if (items.length == 1) {
                        startsWithValue = items[0];
                    } else if (items.length == 2) {
                        startsWithValue = items[0];
                        endsWithValue = items[1];
                    } else {
                        startsWithValue = items[0];
                        endsWithValue = items[items.length - 1];
                        containsValues = new String[items.length - 2];
                        System.arraycopy(items, 1, containsValues, 0, containsValues.length);
                    }
                    segment = new JSONPathFilter.NameMatchFilter(fieldName, hashCode, startsWithValue, endsWithValue, containsValues, operator == JSONPathFilter.Operator.NOT_LIKE);
                    break;
                }
                segment = new JSONPathFilter.NameStringOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, (JSONPathFilter.Operator)operator, strVal);
                break;
            }
            case 't': {
                String ident = this.jsonReader.readFieldNameUnquote();
                if (!"true".equalsIgnoreCase(ident)) break;
                segment = new JSONPathFilter.NameIntOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, (JSONPathFilter.Operator)operator, 1L);
                break;
            }
            case 'f': {
                String ident = this.jsonReader.readFieldNameUnquote();
                if (!"false".equalsIgnoreCase(ident)) break;
                segment = new JSONPathFilter.NameIntOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, (JSONPathFilter.Operator)operator, 0L);
                break;
            }
            case '[': {
                JSONArray array = this.jsonReader.read(JSONArray.class);
                segment = new JSONPathFilter.NameArrayOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, (JSONPathFilter.Operator)operator, array);
                break;
            }
            case '{': {
                JSONObject object = this.jsonReader.read(JSONObject.class);
                segment = new JSONPathFilter.NameObjectOpSegment(fieldName, hashCode, fieldName2, hashCode2, function, (JSONPathFilter.Operator)operator, object);
                break;
            }
            case 'n': {
                boolean nextNull = this.jsonReader.nextIfNull();
                if (nextNull) {
                    segment = new JSONPathFilter.NameIsNull(fieldName, hashCode, fieldName2, hashCode2, function);
                    break;
                }
                throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
            }
            default: {
                throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
            }
        }
        if (this.jsonReader.ch == '&' || this.jsonReader.ch == '|' || this.jsonReader.ch == 'a' || this.jsonReader.ch == 'o') {
            --this.filterNests;
            segment = this.parseFilterRest(segment);
        }
        if (parentheses && !this.jsonReader.nextIfMatch(')')) {
            throw new JSONException(this.jsonReader.info("jsonpath syntax error"));
        }
        return segment;
    }
}

