/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.logging.otlp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import io.opentelemetry.exporter.internal.otlp.traces.ResourceSpansMarshaler;
import io.opentelemetry.exporter.logging.otlp.JsonUtil;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class OtlpJsonLoggingSpanExporter
implements SpanExporter {
    private static final Logger logger = Logger.getLogger(OtlpJsonLoggingSpanExporter.class.getName());
    private final AtomicBoolean isShutdown = new AtomicBoolean();

    public static SpanExporter create() {
        return new OtlpJsonLoggingSpanExporter();
    }

    private OtlpJsonLoggingSpanExporter() {
    }

    @Override
    public CompletableResultCode export(Collection<SpanData> spans) {
        ResourceSpansMarshaler[] allResourceSpans;
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        for (ResourceSpansMarshaler resourceSpans : allResourceSpans = ResourceSpansMarshaler.create(spans)) {
            SegmentedStringWriter sw = new SegmentedStringWriter(JsonUtil.JSON_FACTORY._getBufferRecycler());
            try (JsonGenerator gen = JsonUtil.create(sw);){
                resourceSpans.writeJsonTo(gen);
            }
            catch (IOException e) {
                continue;
            }
            try {
                logger.log(Level.INFO, sw.getAndClear());
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Unable to read OTLP JSON spans", e);
            }
        }
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    @Override
    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            logger.log(Level.INFO, "Calling shutdown() multiple times.");
        }
        return CompletableResultCode.ofSuccess();
    }
}

