/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rocketmq;

import java.util.Map;
import org.apache.camel.component.rocketmq.RocketMQEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;

@Component(value="rocketmq")
public class RocketMQComponent
extends DefaultComponent {
    @Metadata(label="producer")
    private String producerGroup;
    @Metadata(label="consumer")
    private String consumerGroup;
    @Metadata(label="consumer", defaultValue="*")
    private String subscribeTags = "*";
    @Metadata(label="common")
    private String sendTag = "";
    @Metadata(label="common", defaultValue="localhost:9876")
    private String namesrvAddr = "localhost:9876";
    @Metadata(label="producer")
    private String replyToTopic;
    @Metadata(label="producer")
    private String replyToConsumerGroup;
    @Metadata(label="advanced", defaultValue="10000")
    private long requestTimeoutMillis = 10000L;
    @Metadata(label="advanced", defaultValue="1000")
    private long requestTimeoutCheckerIntervalMillis = 1000L;
    @Metadata(label="producer", defaultValue="false")
    private boolean waitForSendResult;
    @Metadata(label="secret", secret=true)
    private String accessKey;
    @Metadata(label="secret", secret=true)
    private String secretKey;

    @Override
    protected RocketMQEndpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        RocketMQEndpoint endpoint = new RocketMQEndpoint(uri, this);
        endpoint.setProducerGroup(this.getProducerGroup());
        endpoint.setConsumerGroup(this.getConsumerGroup());
        endpoint.setSubscribeTags(this.getSubscribeTags());
        endpoint.setNamesrvAddr(this.getNamesrvAddr());
        endpoint.setSendTag(this.getSendTag());
        endpoint.setReplyToTopic(this.getReplyToTopic());
        endpoint.setReplyToConsumerGroup(this.getReplyToConsumerGroup());
        endpoint.setRequestTimeoutMillis(this.getRequestTimeoutMillis());
        endpoint.setRequestTimeoutCheckerIntervalMillis(this.getRequestTimeoutCheckerIntervalMillis());
        endpoint.setWaitForSendResult(this.isWaitForSendResult());
        endpoint.setAccessKey(this.getAccessKey());
        endpoint.setSecretKey(this.getSecretKey());
        this.setProperties(endpoint, parameters);
        endpoint.setTopicName(remaining);
        return endpoint;
    }

    public String getSubscribeTags() {
        return this.subscribeTags;
    }

    public void setSubscribeTags(String subscribeTags) {
        this.subscribeTags = subscribeTags;
    }

    public String getSendTag() {
        return this.sendTag;
    }

    public void setSendTag(String sendTag) {
        this.sendTag = sendTag;
    }

    public String getNamesrvAddr() {
        return this.namesrvAddr;
    }

    public void setNamesrvAddr(String namesrvAddr) {
        this.namesrvAddr = namesrvAddr;
    }

    public String getProducerGroup() {
        return this.producerGroup;
    }

    public void setProducerGroup(String producerGroup) {
        this.producerGroup = producerGroup;
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    public String getReplyToTopic() {
        return this.replyToTopic;
    }

    public void setReplyToTopic(String replyToTopic) {
        this.replyToTopic = replyToTopic;
    }

    public String getReplyToConsumerGroup() {
        return this.replyToConsumerGroup;
    }

    public void setReplyToConsumerGroup(String replyToConsumerGroup) {
        this.replyToConsumerGroup = replyToConsumerGroup;
    }

    public long getRequestTimeoutMillis() {
        return this.requestTimeoutMillis;
    }

    public void setRequestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = requestTimeoutMillis;
    }

    public long getRequestTimeoutCheckerIntervalMillis() {
        return this.requestTimeoutCheckerIntervalMillis;
    }

    public void setRequestTimeoutCheckerIntervalMillis(long requestTimeoutCheckerIntervalMillis) {
        this.requestTimeoutCheckerIntervalMillis = requestTimeoutCheckerIntervalMillis;
    }

    public boolean isWaitForSendResult() {
        return this.waitForSendResult;
    }

    public void setWaitForSendResult(boolean waitForSendResult) {
        this.waitForSendResult = waitForSendResult;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }
}

