/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rocketmq;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Suspendable;
import org.apache.camel.component.rocketmq.RocketMQAclUtils;
import org.apache.camel.component.rocketmq.RocketMQEndpoint;
import org.apache.camel.component.rocketmq.RocketMQMessageConverter;
import org.apache.camel.support.DefaultConsumer;
import org.apache.rocketmq.client.consumer.DefaultMQPushConsumer;
import org.apache.rocketmq.client.consumer.listener.ConsumeConcurrentlyStatus;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.common.message.MessageExt;

public class RocketMQConsumer
extends DefaultConsumer
implements Suspendable {
    private final RocketMQEndpoint endpoint;
    private DefaultMQPushConsumer mqPushConsumer;

    public RocketMQConsumer(RocketMQEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
        this.endpoint = endpoint;
    }

    private void startConsumer() throws MQClientException {
        this.mqPushConsumer = new DefaultMQPushConsumer(null, this.endpoint.getConsumerGroup(), RocketMQAclUtils.getAclRPCHook(this.getEndpoint().getAccessKey(), this.getEndpoint().getSecretKey()));
        this.mqPushConsumer.setNamesrvAddr(this.endpoint.getNamesrvAddr());
        this.mqPushConsumer.subscribe(this.endpoint.getTopicName(), this.endpoint.getSubscribeTags());
        this.mqPushConsumer.registerMessageListener((msgs, context) -> {
            MessageExt messageExt = (MessageExt)msgs.get(0);
            Exchange exchange = this.endpoint.createRocketExchange(messageExt.getBody());
            RocketMQMessageConverter.populateHeadersByMessageExt(exchange.getIn(), messageExt);
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                this.getExceptionHandler().handleException(e);
                return ConsumeConcurrentlyStatus.RECONSUME_LATER;
            }
            return ConsumeConcurrentlyStatus.CONSUME_SUCCESS;
        });
        this.mqPushConsumer.start();
    }

    private void stopConsumer() {
        if (this.mqPushConsumer != null) {
            this.mqPushConsumer.shutdown();
            this.mqPushConsumer = null;
        }
    }

    @Override
    public RocketMQEndpoint getEndpoint() {
        return (RocketMQEndpoint)super.getEndpoint();
    }

    @Override
    protected void doSuspend() {
        this.stopConsumer();
    }

    @Override
    protected void doResume() throws Exception {
        this.startConsumer();
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        this.startConsumer();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this.stopConsumer();
    }
}

