/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.trace.hook;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tag;
import io.opentracing.tag.Tags;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.client.hook.ConsumeMessageContext;
import org.apache.rocketmq.client.hook.ConsumeMessageHook;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;

public class ConsumeMessageOpenTracingHookImpl
implements ConsumeMessageHook {
    private Tracer tracer;

    public ConsumeMessageOpenTracingHookImpl(Tracer tracer) {
        this.tracer = tracer;
    }

    @Override
    public String hookName() {
        return "ConsumeMessageOpenTracingHook";
    }

    @Override
    public void consumeMessageBefore(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        ArrayList<Span> spanList = new ArrayList<Span>();
        for (MessageExt msg : context.getMsgList()) {
            if (msg == null) continue;
            Tracer.SpanBuilder spanBuilder = this.tracer.buildSpan("From_" + msg.getTopic()).withTag((Tag)Tags.SPAN_KIND, (Object)"consumer");
            SpanContext spanContext = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(msg.getProperties()));
            if (spanContext != null) {
                spanBuilder.asChildOf(spanContext);
            }
            Span span = spanBuilder.start();
            span.setTag((Tag)Tags.PEER_SERVICE, (Object)"rocketmq");
            span.setTag((Tag)Tags.MESSAGE_BUS_DESTINATION, (Object)NamespaceUtil.withoutNamespace(msg.getTopic()));
            span.setTag("rocketmq.mgs_id", msg.getMsgId());
            span.setTag("rocketmq.tags", msg.getTags());
            span.setTag("rocketmq.keys", msg.getKeys());
            span.setTag("rocketmq.body_length", (Number)msg.getStoreSize());
            span.setTag("rocketmq.retry_times", (Number)msg.getReconsumeTimes());
            span.setTag("rocketmq.region_id", msg.getProperty("MSG_REGION"));
            spanList.add(span);
        }
        context.setMqTraceContext(spanList);
    }

    @Override
    public void consumeMessageAfter(ConsumeMessageContext context) {
        if (context == null || context.getMsgList() == null || context.getMsgList().isEmpty()) {
            return;
        }
        List spanList = (List)context.getMqTraceContext();
        if (spanList == null) {
            return;
        }
        for (Span span : spanList) {
            span.setTag("rocketmq.success", context.isSuccess());
            span.finish();
        }
    }
}

