/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.common.BrokerIdentity;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;

public class ThreadFactoryImpl
implements ThreadFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger("RocketmqCommon");
    private final AtomicLong threadIndex = new AtomicLong(0L);
    private final String threadNamePrefix;
    private final boolean daemon;

    public ThreadFactoryImpl(String threadNamePrefix) {
        this(threadNamePrefix, false);
    }

    public ThreadFactoryImpl(String threadNamePrefix, boolean daemon) {
        this.threadNamePrefix = threadNamePrefix;
        this.daemon = daemon;
    }

    public ThreadFactoryImpl(String threadNamePrefix, BrokerIdentity brokerIdentity) {
        this(threadNamePrefix, false, brokerIdentity);
    }

    public ThreadFactoryImpl(String threadNamePrefix, boolean daemon, BrokerIdentity brokerIdentity) {
        this.daemon = daemon;
        this.threadNamePrefix = brokerIdentity != null && brokerIdentity.isInBrokerContainer() ? brokerIdentity.getIdentifier() + threadNamePrefix : threadNamePrefix;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread thread2 = new Thread(r, this.threadNamePrefix + this.threadIndex.incrementAndGet());
        thread2.setDaemon(this.daemon);
        thread2.setUncaughtExceptionHandler((t2, e) -> LOGGER.error("[BUG] Thread has an uncaught exception, threadId={}, threadName={}", t2.getId(), t2.getName(), e));
        return thread2;
    }
}

