/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.message;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.rocketmq.common.message.MessageConst;

public class Message
implements Serializable {
    private static final long serialVersionUID = 8445773977080406428L;
    private String topic;
    private int flag;
    private Map<String, String> properties;
    private byte[] body;
    private String transactionId;

    public Message() {
    }

    public Message(String topic, byte[] body) {
        this(topic, "", "", 0, body, true);
    }

    public Message(String topic, String tags, String keys2, int flag, byte[] body, boolean waitStoreMsgOK) {
        this.topic = topic;
        this.flag = flag;
        this.body = body;
        if (tags != null && tags.length() > 0) {
            this.setTags(tags);
        }
        if (keys2 != null && keys2.length() > 0) {
            this.setKeys(keys2);
        }
        this.setWaitStoreMsgOK(waitStoreMsgOK);
    }

    public Message(String topic, String tags, byte[] body) {
        this(topic, tags, "", 0, body, true);
    }

    public Message(String topic, String tags, String keys2, byte[] body) {
        this(topic, tags, keys2, 0, body, true);
    }

    public void setKeys(String keys2) {
        this.putProperty("KEYS", keys2);
    }

    void putProperty(String name, String value) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        this.properties.put(name, value);
    }

    void clearProperty(String name) {
        if (null != this.properties) {
            this.properties.remove(name);
        }
    }

    public void putUserProperty(String name, String value) {
        if (MessageConst.STRING_HASH_SET.contains(name)) {
            throw new RuntimeException(String.format("The Property<%s> is used by system, input another please", name));
        }
        if (value == null || value.trim().isEmpty() || name == null || name.trim().isEmpty()) {
            throw new IllegalArgumentException("The name or value of property can not be null or blank string!");
        }
        this.putProperty(name, value);
    }

    public String getUserProperty(String name) {
        return this.getProperty(name);
    }

    public String getProperty(String name) {
        if (null == this.properties) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties.get(name);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getTags() {
        return this.getProperty("TAGS");
    }

    public void setTags(String tags) {
        this.putProperty("TAGS", tags);
    }

    public String getKeys() {
        return this.getProperty("KEYS");
    }

    public void setKeys(Collection<String> keyCollection) {
        String keys2 = String.join((CharSequence)" ", keyCollection);
        this.setKeys(keys2);
    }

    public int getDelayTimeLevel() {
        String t2 = this.getProperty("DELAY");
        if (t2 != null) {
            return Integer.parseInt(t2);
        }
        return 0;
    }

    public void setDelayTimeLevel(int level) {
        this.putProperty("DELAY", String.valueOf(level));
    }

    public boolean isWaitStoreMsgOK() {
        String result = this.getProperty("WAIT");
        if (null == result) {
            return true;
        }
        return Boolean.parseBoolean(result);
    }

    public void setWaitStoreMsgOK(boolean waitStoreMsgOK) {
        this.putProperty("WAIT", Boolean.toString(waitStoreMsgOK));
    }

    public void setInstanceId(String instanceId) {
        this.putProperty("INSTANCE_ID", instanceId);
    }

    public int getFlag() {
        return this.flag;
    }

    public void setFlag(int flag) {
        this.flag = flag;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String getBuyerId() {
        return this.getProperty("BUYER_ID");
    }

    public void setBuyerId(String buyerId) {
        this.putProperty("BUYER_ID", buyerId);
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String toString() {
        return "Message{topic='" + this.topic + '\'' + ", flag=" + this.flag + ", properties=" + this.properties + ", body=" + Arrays.toString(this.body) + ", transactionId='" + this.transactionId + '\'' + '}';
    }

    public void setDelayTimeSec(long sec) {
        this.putProperty("TIMER_DELAY_SEC", String.valueOf(sec));
    }

    public long getDelayTimeSec() {
        String t2 = this.getProperty("TIMER_DELAY_SEC");
        if (t2 != null) {
            return Long.parseLong(t2);
        }
        return 0L;
    }

    public void setDelayTimeMs(long timeMs) {
        this.putProperty("TIMER_DELAY_MS", String.valueOf(timeMs));
    }

    public long getDelayTimeMs() {
        String t2 = this.getProperty("TIMER_DELAY_MS");
        if (t2 != null) {
            return Long.parseLong(t2);
        }
        return 0L;
    }

    public void setDeliverTimeMs(long timeMs) {
        this.putProperty("TIMER_DELIVER_MS", String.valueOf(timeMs));
    }

    public long getDeliverTimeMs() {
        String t2 = this.getProperty("TIMER_DELIVER_MS");
        if (t2 != null) {
            return Long.parseLong(t2);
        }
        return 0L;
    }
}

