/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.statistics;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;

public class FutureHolder<T> {
    private ConcurrentMap<T, BlockingQueue<Future>> futureMap = new ConcurrentHashMap<T, BlockingQueue<Future>>(8);

    public void addFuture(T t2, Future future) {
        BlockingQueue old;
        BlockingQueue<Future<Object>> list = (LinkedBlockingQueue<Future>)this.futureMap.get(t2);
        if (list == null && (old = (BlockingQueue)this.futureMap.putIfAbsent(t2, list = new LinkedBlockingQueue<Future>())) != null) {
            list = old;
        }
        list.add(future);
    }

    public void removeAllFuture(T t2) {
        this.cancelAll(t2, false);
        this.futureMap.remove(t2);
    }

    private void cancelAll(T t2, boolean mayInterruptIfRunning) {
        BlockingQueue list = (BlockingQueue)this.futureMap.get(t2);
        if (list != null) {
            for (Future future : list) {
                future.cancel(mayInterruptIfRunning);
            }
        }
    }
}

