/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.utils;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public class FutureUtils {
    public static <T> CompletableFuture<T> appendNextFuture(CompletableFuture<T> future, CompletableFuture<T> nextFuture, ExecutorService executor) {
        future.whenCompleteAsync((t2, throwable) -> {
            if (throwable != null) {
                nextFuture.completeExceptionally((Throwable)throwable);
            } else {
                nextFuture.complete(t2);
            }
        }, (Executor)executor);
        return nextFuture;
    }

    public static <T> CompletableFuture<T> addExecutor(CompletableFuture<T> future, ExecutorService executor) {
        return FutureUtils.appendNextFuture(future, new CompletableFuture(), executor);
    }

    public static <T> CompletableFuture<T> completeExceptionally(Throwable t2) {
        CompletableFuture future = new CompletableFuture();
        future.completeExceptionally(t2);
        return future;
    }
}

