/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.stub;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import io.grpc.ClientCall;
import io.grpc.ExperimentalApi;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.ClientCalls;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/10918")
public final class BlockingClientCall<ReqT, RespT> {
    private static final Logger logger = Logger.getLogger(BlockingClientCall.class.getName());
    private final BlockingQueue<RespT> buffer;
    private final ClientCall<ReqT, RespT> call;
    private final ClientCalls.ThreadSafeThreadlessExecutor executor;
    private boolean writeClosed;
    private volatile Status closedStatus;

    BlockingClientCall(ClientCall<ReqT, RespT> call, ClientCalls.ThreadSafeThreadlessExecutor executor) {
        this.call = call;
        this.executor = executor;
        this.buffer = new ArrayBlockingQueue<RespT>(1);
    }

    public RespT read() throws InterruptedException, StatusException {
        try {
            return this.read(true, 0L);
        }
        catch (TimeoutException e) {
            throw new AssertionError("should never happen", e);
        }
    }

    public RespT read(long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        long endNanoTime = System.nanoTime() + unit.toNanos(timeout2);
        return this.read(false, endNanoTime);
    }

    private RespT read(boolean waitForever, long endNanoTime) throws InterruptedException, TimeoutException, StatusException {
        Predicate predicate = BlockingClientCall::skipWaitingForRead;
        this.executor.waitAndDrainWithTimeout(waitForever, endNanoTime, predicate, this);
        Object bufferedValue = this.buffer.poll();
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Client Blocking read had value:  " + bufferedValue);
        }
        if (bufferedValue != null) {
            this.call.request(1);
            return (RespT)bufferedValue;
        }
        Status currentClosedStatus = this.closedStatus;
        if (currentClosedStatus == null) {
            throw new IllegalStateException("The message disappeared... are you reading from multiple threads?");
        }
        if (!currentClosedStatus.isOk()) {
            throw currentClosedStatus.asException();
        }
        return null;
    }

    boolean skipWaitingForRead() {
        return this.closedStatus != null || !this.buffer.isEmpty();
    }

    public boolean hasNext() throws InterruptedException, StatusException {
        this.executor.waitAndDrain(x -> !x.buffer.isEmpty() || x.closedStatus != null, this);
        Status currentClosedStatus = this.closedStatus;
        if (currentClosedStatus != null && !currentClosedStatus.isOk()) {
            throw currentClosedStatus.asException();
        }
        return !this.buffer.isEmpty();
    }

    public boolean write(ReqT request) throws InterruptedException, StatusException {
        try {
            return this.write(true, request, 0L);
        }
        catch (TimeoutException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean write(ReqT request, long timeout2, TimeUnit unit) throws InterruptedException, TimeoutException, StatusException {
        long endNanoTime = System.nanoTime() + unit.toNanos(timeout2);
        return this.write(false, request, endNanoTime);
    }

    private boolean write(boolean waitForever, ReqT request, long endNanoTime) throws InterruptedException, TimeoutException, StatusException {
        if (this.writeClosed) {
            throw new IllegalStateException("Writes cannot be done after calling halfClose or cancel");
        }
        Predicate predicate = x -> x.call.isReady() || x.closedStatus != null;
        this.executor.waitAndDrainWithTimeout(waitForever, endNanoTime, predicate, this);
        Status savedClosedStatus = this.closedStatus;
        if (savedClosedStatus == null) {
            this.call.sendMessage(request);
            return true;
        }
        if (savedClosedStatus.isOk()) {
            return false;
        }
        throw savedClosedStatus.asException();
    }

    void sendSingleRequest(ReqT request) {
        this.call.sendMessage(request);
    }

    public void cancel(String message, Throwable cause) {
        this.writeClosed = true;
        this.call.cancel(message, cause);
    }

    public void halfClose() {
        if (this.writeClosed) {
            throw new IllegalStateException("halfClose cannot be called after already half closed or cancelled");
        }
        this.writeClosed = true;
        this.call.halfClose();
    }

    @VisibleForTesting
    Status getClosedStatus() {
        this.drainQuietly();
        return this.closedStatus;
    }

    @VisibleForTesting
    boolean isEitherReadOrWriteReady() {
        return this.isWriteLegal() && this.isWriteReady() || this.isReadReady();
    }

    @VisibleForTesting
    boolean isReadReady() {
        this.drainQuietly();
        return !this.buffer.isEmpty();
    }

    @VisibleForTesting
    boolean isWriteReady() {
        this.drainQuietly();
        return this.isWriteLegal() && this.call.isReady();
    }

    private boolean isWriteLegal() {
        return !this.writeClosed && this.closedStatus == null;
    }

    ClientCall.Listener<RespT> getListener() {
        return new QueuingListener();
    }

    private void drainQuietly() {
        try {
            this.executor.drain();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private final class QueuingListener
    extends ClientCall.Listener<RespT> {
        private QueuingListener() {
        }

        @Override
        public void onMessage(RespT value) {
            Preconditions.checkState(BlockingClientCall.this.closedStatus == null, "ClientCall already closed");
            BlockingClientCall.this.buffer.add(value);
        }

        @Override
        public void onClose(Status status, Metadata trailers) {
            Preconditions.checkState(BlockingClientCall.this.closedStatus == null, "ClientCall already closed");
            BlockingClientCall.this.closedStatus = status;
        }
    }
}

