/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.consumer.store;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.rocketmq.client.consumer.store.ControllableOffset;
import org.apache.rocketmq.client.consumer.store.OffsetSerializeWrapper;
import org.apache.rocketmq.client.consumer.store.OffsetStore;
import org.apache.rocketmq.client.consumer.store.ReadOffsetType;
import org.apache.rocketmq.client.exception.MQBrokerException;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.common.MixAll;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.help.FAQUrl;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.exception.RemotingException;

public class LocalFileOffsetStore
implements OffsetStore {
    public static final String LOCAL_OFFSET_STORE_DIR = System.getProperty("rocketmq.client.localOffsetStoreDir", System.getProperty("user.home") + File.separator + ".rocketmq_offsets");
    private static final Logger log = LoggerFactory.getLogger(LocalFileOffsetStore.class);
    private final MQClientInstance mQClientFactory;
    private final String groupName;
    private final String storePath;
    private ConcurrentMap<MessageQueue, ControllableOffset> offsetTable = new ConcurrentHashMap<MessageQueue, ControllableOffset>();

    public LocalFileOffsetStore(MQClientInstance mQClientFactory, String groupName) {
        this.mQClientFactory = mQClientFactory;
        this.groupName = groupName;
        this.storePath = LOCAL_OFFSET_STORE_DIR + File.separator + this.mQClientFactory.getClientId() + File.separator + this.groupName + File.separator + "offsets.json";
    }

    @Override
    public void load() throws MQClientException {
        OffsetSerializeWrapper offsetSerializeWrapper = this.readLocalOffset();
        if (offsetSerializeWrapper != null && offsetSerializeWrapper.getOffsetTable() != null) {
            for (Map.Entry mqEntry : offsetSerializeWrapper.getOffsetTable().entrySet()) {
                AtomicLong offset = (AtomicLong)mqEntry.getValue();
                this.offsetTable.put((MessageQueue)mqEntry.getKey(), new ControllableOffset(offset.get()));
                log.info("load consumer's offset, {} {} {}", this.groupName, mqEntry.getKey(), offset.get());
            }
        }
    }

    @Override
    public void updateOffset(MessageQueue mq, long offset, boolean increaseOnly) {
        if (mq != null) {
            ControllableOffset offsetOld = (ControllableOffset)this.offsetTable.get(mq);
            if (null == offsetOld) {
                offsetOld = this.offsetTable.putIfAbsent(mq, new ControllableOffset(offset));
            }
            if (null != offsetOld) {
                if (increaseOnly) {
                    offsetOld.update(offset, true);
                } else {
                    offsetOld.update(offset);
                }
            }
        }
    }

    @Override
    public void updateAndFreezeOffset(MessageQueue mq, long offset) {
        if (mq != null) {
            this.offsetTable.computeIfAbsent(mq, k -> new ControllableOffset(offset)).updateAndFreeze(offset);
        }
    }

    @Override
    public long readOffset(MessageQueue mq, ReadOffsetType type) {
        if (mq != null) {
            switch (type) {
                case MEMORY_FIRST_THEN_STORE: 
                case READ_FROM_MEMORY: {
                    ControllableOffset offset = (ControllableOffset)this.offsetTable.get(mq);
                    if (offset != null) {
                        return offset.getOffset();
                    }
                    if (ReadOffsetType.READ_FROM_MEMORY == type) {
                        return -1L;
                    }
                }
                case READ_FROM_STORE: {
                    AtomicLong offset;
                    OffsetSerializeWrapper offsetSerializeWrapper;
                    try {
                        offsetSerializeWrapper = this.readLocalOffset();
                    }
                    catch (MQClientException e) {
                        return -1L;
                    }
                    if (offsetSerializeWrapper == null || offsetSerializeWrapper.getOffsetTable() == null || (offset = (AtomicLong)offsetSerializeWrapper.getOffsetTable().get(mq)) == null) break;
                    this.updateOffset(mq, offset.get(), false);
                    return offset.get();
                }
            }
        }
        return -1L;
    }

    @Override
    public void persistAll(Set<MessageQueue> mqs) {
        if (null == mqs || mqs.isEmpty()) {
            return;
        }
        OffsetSerializeWrapper offsetSerializeWrapper = null;
        try {
            offsetSerializeWrapper = this.readLocalOffset();
        }
        catch (MQClientException e) {
            log.error("readLocalOffset exception", e);
            return;
        }
        if (offsetSerializeWrapper == null) {
            offsetSerializeWrapper = new OffsetSerializeWrapper();
        }
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            if (!mqs.contains(entry.getKey())) continue;
            AtomicLong offset = new AtomicLong(((ControllableOffset)entry.getValue()).getOffset());
            offsetSerializeWrapper.getOffsetTable().put((MessageQueue)entry.getKey(), offset);
        }
        String jsonString = offsetSerializeWrapper.toJson(true);
        if (jsonString != null) {
            try {
                MixAll.string2File(jsonString, this.storePath);
            }
            catch (IOException e) {
                log.error("persistAll consumer offset Exception, " + this.storePath, e);
            }
        }
    }

    @Override
    public void persist(MessageQueue mq) {
        if (mq == null) {
            return;
        }
        ControllableOffset offset = (ControllableOffset)this.offsetTable.get(mq);
        if (offset != null) {
            OffsetSerializeWrapper offsetSerializeWrapper = null;
            try {
                offsetSerializeWrapper = this.readLocalOffset();
            }
            catch (MQClientException e) {
                log.error("readLocalOffset exception", e);
                return;
            }
            if (offsetSerializeWrapper == null) {
                offsetSerializeWrapper = new OffsetSerializeWrapper();
            }
            offsetSerializeWrapper.getOffsetTable().put(mq, new AtomicLong(offset.getOffset()));
            String jsonString = offsetSerializeWrapper.toJson(true);
            if (jsonString != null) {
                try {
                    MixAll.string2File(jsonString, this.storePath);
                }
                catch (IOException e) {
                    log.error("persist consumer offset exception, " + this.storePath, e);
                }
            }
        }
    }

    @Override
    public void removeOffset(MessageQueue mq) {
        if (mq != null) {
            this.offsetTable.remove(mq);
            log.info("remove unnecessary messageQueue offset. group={}, mq={}, offsetTableSize={}", this.groupName, mq, this.offsetTable.size());
        }
    }

    @Override
    public void updateConsumeOffsetToBroker(MessageQueue mq, long offset, boolean isOneway) throws RemotingException, MQBrokerException, InterruptedException, MQClientException {
    }

    @Override
    public Map<MessageQueue, Long> cloneOffsetTable(String topic) {
        HashMap<MessageQueue, Long> cloneOffsetTable = new HashMap<MessageQueue, Long>(this.offsetTable.size(), 1.0f);
        for (Map.Entry entry : this.offsetTable.entrySet()) {
            MessageQueue mq = (MessageQueue)entry.getKey();
            if (!UtilAll.isBlank(topic) && !topic.equals(mq.getTopic())) continue;
            cloneOffsetTable.put(mq, ((ControllableOffset)entry.getValue()).getOffset());
        }
        return cloneOffsetTable;
    }

    private OffsetSerializeWrapper readLocalOffset() throws MQClientException {
        String content = null;
        try {
            content = MixAll.file2String(this.storePath);
        }
        catch (IOException e) {
            log.warn("Load local offset store file exception", e);
        }
        if (null == content || content.length() == 0) {
            return this.readLocalOffsetBak();
        }
        OffsetSerializeWrapper offsetSerializeWrapper = null;
        try {
            offsetSerializeWrapper = OffsetSerializeWrapper.fromJson(content, OffsetSerializeWrapper.class);
        }
        catch (Exception e) {
            log.warn("readLocalOffset Exception, and try to correct", e);
            return this.readLocalOffsetBak();
        }
        return offsetSerializeWrapper;
    }

    private OffsetSerializeWrapper readLocalOffsetBak() throws MQClientException {
        String content = null;
        try {
            content = MixAll.file2String(this.storePath + ".bak");
        }
        catch (IOException e) {
            log.warn("Load local offset store bak file exception", e);
        }
        if (content != null && content.length() > 0) {
            OffsetSerializeWrapper offsetSerializeWrapper = null;
            try {
                offsetSerializeWrapper = OffsetSerializeWrapper.fromJson(content, OffsetSerializeWrapper.class);
            }
            catch (Exception e) {
                log.warn("readLocalOffset Exception", e);
                throw new MQClientException("readLocalOffset Exception, maybe fastjson version too low" + FAQUrl.suggestTodo("https://rocketmq.apache.org/docs/bestPractice/06FAQ"), e);
            }
            return offsetSerializeWrapper;
        }
        return null;
    }
}

