/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.filter;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.remoting.protocol.heartbeat.SubscriptionData;

public class FilterAPI {
    public static SubscriptionData buildSubscriptionData(String topic, String subString) throws Exception {
        SubscriptionData subscriptionData = new SubscriptionData();
        subscriptionData.setTopic(topic);
        subscriptionData.setSubString(subString);
        if (StringUtils.isEmpty(subString) || subString.equals("*")) {
            subscriptionData.setSubString("*");
            return subscriptionData;
        }
        String[] tags = subString.split("\\|\\|");
        if (tags.length <= 0) {
            throw new Exception("subString split error");
        }
        Arrays.stream(tags).map(String::trim).filter(tag -> !tag.isEmpty()).forEach(tag -> {
            subscriptionData.getTagsSet().add((String)tag);
            subscriptionData.getCodeSet().add(tag.hashCode());
        });
        return subscriptionData;
    }

    public static SubscriptionData buildSubscriptionData(String topic, String subString, String expressionType) throws Exception {
        SubscriptionData subscriptionData = FilterAPI.buildSubscriptionData(topic, subString);
        if (StringUtils.isNotBlank(expressionType)) {
            subscriptionData.setExpressionType(expressionType);
        }
        return subscriptionData;
    }

    public static SubscriptionData build(String topic, String subString, String type) throws Exception {
        if ("TAG".equals(type) || type == null) {
            return FilterAPI.buildSubscriptionData(topic, subString);
        }
        if (StringUtils.isEmpty(subString)) {
            throw new IllegalArgumentException("Expression can't be null! " + type);
        }
        SubscriptionData subscriptionData = new SubscriptionData();
        subscriptionData.setTopic(topic);
        subscriptionData.setSubString(subString);
        subscriptionData.setExpressionType(type);
        return subscriptionData;
    }
}

