/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.header;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import org.apache.rocketmq.common.action.Action;
import org.apache.rocketmq.common.action.RocketMQAction;
import org.apache.rocketmq.common.resource.ResourceType;
import org.apache.rocketmq.common.resource.RocketMQResource;
import org.apache.rocketmq.remoting.annotation.CFNotNull;
import org.apache.rocketmq.remoting.annotation.CFNullable;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.protocol.FastCodesHeader;
import org.apache.rocketmq.remoting.rpc.TopicQueueRequestHeader;

@RocketMQAction(value=11, action={Action.SUB})
public class PullMessageRequestHeader
extends TopicQueueRequestHeader
implements FastCodesHeader {
    @CFNotNull
    @RocketMQResource(value=ResourceType.GROUP)
    private String consumerGroup;
    @CFNotNull
    @RocketMQResource(value=ResourceType.TOPIC)
    private String topic;
    @CFNotNull
    private Integer queueId;
    @CFNotNull
    private Long queueOffset;
    @CFNotNull
    private Integer maxMsgNums;
    @CFNotNull
    private Integer sysFlag;
    @CFNotNull
    private Long commitOffset;
    @CFNotNull
    private Long suspendTimeoutMillis;
    @CFNullable
    private String subscription;
    @CFNotNull
    private Long subVersion;
    private String expressionType;
    @CFNullable
    private Integer maxMsgBytes;
    private Integer requestSource;
    private String proxyFrowardClientId;

    @Override
    public void checkFields() throws RemotingCommandException {
    }

    @Override
    public void encode(ByteBuf out) {
        this.writeIfNotNull(out, "consumerGroup", this.consumerGroup);
        this.writeIfNotNull(out, "topic", this.topic);
        this.writeIfNotNull(out, "queueId", this.queueId);
        this.writeIfNotNull(out, "queueOffset", this.queueOffset);
        this.writeIfNotNull(out, "maxMsgNums", this.maxMsgNums);
        this.writeIfNotNull(out, "sysFlag", this.sysFlag);
        this.writeIfNotNull(out, "commitOffset", this.commitOffset);
        this.writeIfNotNull(out, "suspendTimeoutMillis", this.suspendTimeoutMillis);
        this.writeIfNotNull(out, "subscription", this.subscription);
        this.writeIfNotNull(out, "subVersion", this.subVersion);
        this.writeIfNotNull(out, "expressionType", this.expressionType);
        this.writeIfNotNull(out, "maxMsgBytes", this.maxMsgBytes);
        this.writeIfNotNull(out, "requestSource", this.requestSource);
        this.writeIfNotNull(out, "proxyFrowardClientId", this.proxyFrowardClientId);
        this.writeIfNotNull(out, "lo", this.lo);
        this.writeIfNotNull(out, "ns", this.ns);
        this.writeIfNotNull(out, "nsd", this.nsd);
        this.writeIfNotNull(out, "bname", this.bname);
        this.writeIfNotNull(out, "oway", this.oway);
    }

    @Override
    public void decode(HashMap<String, String> fields) throws RemotingCommandException {
        String str = this.getAndCheckNotNull(fields, "consumerGroup");
        if (str != null) {
            this.consumerGroup = str;
        }
        if ((str = this.getAndCheckNotNull(fields, "topic")) != null) {
            this.topic = str;
        }
        if ((str = this.getAndCheckNotNull(fields, "queueId")) != null) {
            this.queueId = Integer.parseInt(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "queueOffset")) != null) {
            this.queueOffset = Long.parseLong(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "maxMsgNums")) != null) {
            this.maxMsgNums = Integer.parseInt(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "sysFlag")) != null) {
            this.sysFlag = Integer.parseInt(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "commitOffset")) != null) {
            this.commitOffset = Long.parseLong(str);
        }
        if ((str = this.getAndCheckNotNull(fields, "suspendTimeoutMillis")) != null) {
            this.suspendTimeoutMillis = Long.parseLong(str);
        }
        if ((str = fields.get("subscription")) != null) {
            this.subscription = str;
        }
        if ((str = this.getAndCheckNotNull(fields, "subVersion")) != null) {
            this.subVersion = Long.parseLong(str);
        }
        if ((str = fields.get("expressionType")) != null) {
            this.expressionType = str;
        }
        if ((str = fields.get("maxMsgBytes")) != null) {
            this.maxMsgBytes = Integer.parseInt(str);
        }
        if ((str = fields.get("requestSource")) != null) {
            this.requestSource = Integer.parseInt(str);
        }
        if ((str = fields.get("proxyFrowardClientId")) != null) {
            this.proxyFrowardClientId = str;
        }
        if ((str = fields.get("lo")) != null) {
            this.lo = Boolean.parseBoolean(str);
        }
        if ((str = fields.get("ns")) != null) {
            this.ns = str;
        }
        if ((str = fields.get("nsd")) != null) {
            this.nsd = Boolean.parseBoolean(str);
        }
        if ((str = fields.get("bname")) != null) {
            this.bname = str;
        }
        if ((str = fields.get("oway")) != null) {
            this.oway = Boolean.parseBoolean(str);
        }
    }

    public String getConsumerGroup() {
        return this.consumerGroup;
    }

    public void setConsumerGroup(String consumerGroup) {
        this.consumerGroup = consumerGroup;
    }

    @Override
    public String getTopic() {
        return this.topic;
    }

    @Override
    public void setTopic(String topic) {
        this.topic = topic;
    }

    @Override
    public Integer getQueueId() {
        return this.queueId;
    }

    @Override
    public void setQueueId(Integer queueId) {
        this.queueId = queueId;
    }

    public Long getQueueOffset() {
        return this.queueOffset;
    }

    public void setQueueOffset(Long queueOffset) {
        this.queueOffset = queueOffset;
    }

    public Integer getMaxMsgNums() {
        return this.maxMsgNums;
    }

    public void setMaxMsgNums(Integer maxMsgNums) {
        this.maxMsgNums = maxMsgNums;
    }

    public Integer getSysFlag() {
        return this.sysFlag;
    }

    public void setSysFlag(Integer sysFlag) {
        this.sysFlag = sysFlag;
    }

    public Long getCommitOffset() {
        return this.commitOffset;
    }

    public void setCommitOffset(Long commitOffset) {
        this.commitOffset = commitOffset;
    }

    public Long getSuspendTimeoutMillis() {
        return this.suspendTimeoutMillis;
    }

    public void setSuspendTimeoutMillis(Long suspendTimeoutMillis) {
        this.suspendTimeoutMillis = suspendTimeoutMillis;
    }

    public String getSubscription() {
        return this.subscription;
    }

    public void setSubscription(String subscription) {
        this.subscription = subscription;
    }

    public Long getSubVersion() {
        return this.subVersion;
    }

    public void setSubVersion(Long subVersion) {
        this.subVersion = subVersion;
    }

    public String getExpressionType() {
        return this.expressionType;
    }

    public void setExpressionType(String expressionType) {
        this.expressionType = expressionType;
    }

    public Integer getMaxMsgBytes() {
        return this.maxMsgBytes;
    }

    public void setMaxMsgBytes(Integer maxMsgBytes) {
        this.maxMsgBytes = maxMsgBytes;
    }

    public Integer getRequestSource() {
        return this.requestSource;
    }

    public void setRequestSource(Integer requestSource) {
        this.requestSource = requestSource;
    }

    public String getProxyFrowardClientId() {
        return this.proxyFrowardClientId;
    }

    public void setProxyFrowardClientId(String proxyFrowardClientId) {
        this.proxyFrowardClientId = proxyFrowardClientId;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("consumerGroup", this.consumerGroup).add("topic", this.topic).add("queueId", this.queueId).add("queueOffset", this.queueOffset).add("maxMsgBytes", this.maxMsgBytes).add("maxMsgNums", this.maxMsgNums).add("sysFlag", this.sysFlag).add("commitOffset", this.commitOffset).add("suspendTimeoutMillis", this.suspendTimeoutMillis).add("subscription", this.subscription).add("subVersion", this.subVersion).add("expressionType", this.expressionType).add("requestSource", this.requestSource).add("proxyFrowardClientId", this.proxyFrowardClientId).toString();
    }
}

