/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.body;

import com.alibaba.fastjson.JSON;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.common.TopicConfig;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.protocol.DataVersion;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;
import org.apache.rocketmq.remoting.protocol.body.TopicConfigAndMappingSerializeWrapper;
import org.apache.rocketmq.remoting.protocol.statictopic.TopicQueueMappingInfo;

public class RegisterBrokerBody
extends RemotingSerializable {
    private static final Logger LOGGER = LoggerFactory.getLogger("RocketmqCommon");
    private TopicConfigAndMappingSerializeWrapper topicConfigSerializeWrapper = new TopicConfigAndMappingSerializeWrapper();
    private List<String> filterServerList = new ArrayList<String>();
    private static final long MINIMUM_TAKE_TIME_MILLISECOND = 50L;

    public byte[] encode(boolean compress) {
        if (!compress) {
            return super.encode();
        }
        long start = System.currentTimeMillis();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream outputStream2 = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, new Deflater(9));
        DataVersion dataVersion = this.topicConfigSerializeWrapper.getDataVersion();
        ConcurrentMap<String, TopicConfig> topicConfigTable = this.cloneTopicConfigTable(this.topicConfigSerializeWrapper.getTopicConfigTable());
        assert (topicConfigTable != null);
        try {
            byte[] buffer = dataVersion.encode();
            outputStream2.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
            outputStream2.write(buffer);
            int topicNumber = topicConfigTable.size();
            outputStream2.write(RegisterBrokerBody.convertIntToByteArray(topicNumber));
            for (Map.Entry entry : topicConfigTable.entrySet()) {
                buffer = ((TopicConfig)entry.getValue()).encode().getBytes("UTF-8");
                outputStream2.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
                outputStream2.write(buffer);
            }
            buffer = JSON.toJSONString(this.filterServerList).getBytes("UTF-8");
            outputStream2.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
            outputStream2.write(buffer);
            Map<String, TopicQueueMappingInfo> topicQueueMappingInfoMap = this.topicConfigSerializeWrapper.getTopicQueueMappingInfoMap();
            if (topicQueueMappingInfoMap == null) {
                topicQueueMappingInfoMap = new ConcurrentHashMap<String, TopicQueueMappingInfo>();
            }
            outputStream2.write(RegisterBrokerBody.convertIntToByteArray(topicQueueMappingInfoMap.size()));
            for (TopicQueueMappingInfo info : topicQueueMappingInfoMap.values()) {
                buffer = JSON.toJSONString(info).getBytes("UTF-8");
                outputStream2.write(RegisterBrokerBody.convertIntToByteArray(buffer.length));
                outputStream2.write(buffer);
            }
            outputStream2.finish();
            long l = System.currentTimeMillis() - start;
            if (l > 50L) {
                LOGGER.info("Compressing takes {}ms", (Object)l);
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Failed to compress RegisterBrokerBody object", e);
            return null;
        }
    }

    public static RegisterBrokerBody decode(byte[] data, boolean compressed, MQVersion.Version brokerVersion) throws IOException {
        long takeTime;
        if (!compressed) {
            return RegisterBrokerBody.decode(data, RegisterBrokerBody.class);
        }
        long start = System.currentTimeMillis();
        InflaterInputStream inflaterInputStream = new InflaterInputStream(new ByteArrayInputStream(data));
        int dataVersionLength = RegisterBrokerBody.readInt(inflaterInputStream);
        byte[] dataVersionBytes = RegisterBrokerBody.readBytes(inflaterInputStream, dataVersionLength);
        DataVersion dataVersion = DataVersion.decode(dataVersionBytes, DataVersion.class);
        RegisterBrokerBody registerBrokerBody = new RegisterBrokerBody();
        registerBrokerBody.getTopicConfigSerializeWrapper().setDataVersion(dataVersion);
        ConcurrentMap<String, TopicConfig> topicConfigTable = registerBrokerBody.getTopicConfigSerializeWrapper().getTopicConfigTable();
        int topicConfigNumber = RegisterBrokerBody.readInt(inflaterInputStream);
        LOGGER.debug("{} topic configs to extract", (Object)topicConfigNumber);
        for (int i = 0; i < topicConfigNumber; ++i) {
            int topicConfigJsonLength = RegisterBrokerBody.readInt(inflaterInputStream);
            byte[] buffer = RegisterBrokerBody.readBytes(inflaterInputStream, topicConfigJsonLength);
            TopicConfig topicConfig = new TopicConfig();
            String topicConfigJson = new String(buffer, "UTF-8");
            topicConfig.decode(topicConfigJson);
            topicConfigTable.put(topicConfig.getTopicName(), topicConfig);
        }
        int filterServerListJsonLength = RegisterBrokerBody.readInt(inflaterInputStream);
        byte[] filterServerListBuffer = RegisterBrokerBody.readBytes(inflaterInputStream, filterServerListJsonLength);
        String filterServerListJson = new String(filterServerListBuffer, "UTF-8");
        ArrayList<String> filterServerList = new ArrayList();
        try {
            filterServerList = JSON.parseArray(filterServerListJson, String.class);
        }
        catch (Exception e) {
            LOGGER.error("Decompressing occur Exception {}", (Object)filterServerListJson);
        }
        registerBrokerBody.setFilterServerList(filterServerList);
        if (brokerVersion.ordinal() >= MQVersion.Version.V5_0_0.ordinal()) {
            int topicQueueMappingNum = RegisterBrokerBody.readInt(inflaterInputStream);
            ConcurrentHashMap<String, TopicQueueMappingInfo> topicQueueMappingInfoMap = new ConcurrentHashMap<String, TopicQueueMappingInfo>();
            for (int i = 0; i < topicQueueMappingNum; ++i) {
                int mappingJsonLen = RegisterBrokerBody.readInt(inflaterInputStream);
                byte[] buffer = RegisterBrokerBody.readBytes(inflaterInputStream, mappingJsonLen);
                TopicQueueMappingInfo info = TopicQueueMappingInfo.decode(buffer, TopicQueueMappingInfo.class);
                topicQueueMappingInfoMap.put(info.getTopic(), info);
            }
            registerBrokerBody.getTopicConfigSerializeWrapper().setTopicQueueMappingInfoMap(topicQueueMappingInfoMap);
        }
        if ((takeTime = System.currentTimeMillis() - start) > 50L) {
            LOGGER.info("Decompressing takes {}ms", (Object)takeTime);
        }
        return registerBrokerBody;
    }

    private static byte[] convertIntToByteArray(int n) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(n);
        return byteBuffer.array();
    }

    private static byte[] readBytes(InflaterInputStream inflaterInputStream, int length) throws IOException {
        int len;
        byte[] buffer = new byte[length];
        for (int bytesRead = 0; bytesRead < length; bytesRead += len) {
            len = inflaterInputStream.read(buffer, bytesRead, length - bytesRead);
            if (len != -1) continue;
            throw new IOException("End of compressed data has reached");
        }
        return buffer;
    }

    private static int readInt(InflaterInputStream inflaterInputStream) throws IOException {
        byte[] buffer = RegisterBrokerBody.readBytes(inflaterInputStream, 4);
        ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
        return byteBuffer.getInt();
    }

    public TopicConfigAndMappingSerializeWrapper getTopicConfigSerializeWrapper() {
        return this.topicConfigSerializeWrapper;
    }

    public void setTopicConfigSerializeWrapper(TopicConfigAndMappingSerializeWrapper topicConfigSerializeWrapper) {
        this.topicConfigSerializeWrapper = topicConfigSerializeWrapper;
    }

    public List<String> getFilterServerList() {
        return this.filterServerList;
    }

    public void setFilterServerList(List<String> filterServerList) {
        this.filterServerList = filterServerList;
    }

    private ConcurrentMap<String, TopicConfig> cloneTopicConfigTable(ConcurrentMap<String, TopicConfig> topicConfigConcurrentMap) {
        if (topicConfigConcurrentMap == null) {
            return null;
        }
        ConcurrentHashMap<String, TopicConfig> result = new ConcurrentHashMap<String, TopicConfig>(topicConfigConcurrentMap.size());
        result.putAll(topicConfigConcurrentMap);
        return result;
    }
}

