/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol.statictopic;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.rocketmq.remoting.protocol.RemotingSerializable;

public class LogicQueueMappingItem
extends RemotingSerializable {
    private int gen;
    private int queueId;
    private String bname;
    private long logicOffset;
    private long startOffset;
    private long endOffset = -1L;
    private long timeOfStart = -1L;
    private long timeOfEnd = -1L;

    public LogicQueueMappingItem() {
    }

    public LogicQueueMappingItem(int gen, int queueId, String bname, long logicOffset, long startOffset, long endOffset, long timeOfStart, long timeOfEnd) {
        this.gen = gen;
        this.queueId = queueId;
        this.bname = bname;
        this.logicOffset = logicOffset;
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.timeOfStart = timeOfStart;
        this.timeOfEnd = timeOfEnd;
    }

    public long computeStaticQueueOffsetLoosely(long physicalQueueOffset) {
        if (this.logicOffset < 0L) {
            return -1L;
        }
        if (physicalQueueOffset < this.startOffset) {
            return this.logicOffset;
        }
        if (this.endOffset >= this.startOffset && this.endOffset < physicalQueueOffset) {
            return this.logicOffset + (this.endOffset - this.startOffset);
        }
        return this.logicOffset + (physicalQueueOffset - this.startOffset);
    }

    public long computeStaticQueueOffsetStrictly(long physicalQueueOffset) {
        assert (this.logicOffset >= 0L);
        if (physicalQueueOffset < this.startOffset) {
            return this.logicOffset;
        }
        return this.logicOffset + (physicalQueueOffset - this.startOffset);
    }

    public long computePhysicalQueueOffset(long staticQueueOffset) {
        return staticQueueOffset - this.logicOffset + this.startOffset;
    }

    public long computeMaxStaticQueueOffset() {
        if (this.endOffset >= this.startOffset) {
            return this.logicOffset + this.endOffset - this.startOffset;
        }
        return this.logicOffset;
    }

    public boolean checkIfEndOffsetDecided() {
        return this.endOffset > this.startOffset;
    }

    public boolean checkIfLogicoffsetDecided() {
        return this.logicOffset >= 0L;
    }

    public long computeOffsetDelta() {
        return this.logicOffset - this.startOffset;
    }

    public int getGen() {
        return this.gen;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public String getBname() {
        return this.bname;
    }

    public long getLogicOffset() {
        return this.logicOffset;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    public long getTimeOfStart() {
        return this.timeOfStart;
    }

    public long getTimeOfEnd() {
        return this.timeOfEnd;
    }

    public void setLogicOffset(long logicOffset) {
        this.logicOffset = logicOffset;
    }

    public void setEndOffset(long endOffset) {
        this.endOffset = endOffset;
    }

    public void setTimeOfStart(long timeOfStart) {
        this.timeOfStart = timeOfStart;
    }

    public void setTimeOfEnd(long timeOfEnd) {
        this.timeOfEnd = timeOfEnd;
    }

    public void setGen(int gen) {
        this.gen = gen;
    }

    public void setQueueId(int queueId) {
        this.queueId = queueId;
    }

    public void setBname(String bname) {
        this.bname = bname;
    }

    public void setStartOffset(long startOffset) {
        this.startOffset = startOffset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LogicQueueMappingItem)) {
            return false;
        }
        LogicQueueMappingItem item = (LogicQueueMappingItem)o;
        return new EqualsBuilder().append(this.gen, item.gen).append(this.queueId, item.queueId).append(this.logicOffset, item.logicOffset).append(this.startOffset, item.startOffset).append(this.endOffset, item.endOffset).append(this.timeOfStart, item.timeOfStart).append(this.timeOfEnd, item.timeOfEnd).append(this.bname, item.bname).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.gen).append(this.queueId).append(this.bname).append(this.logicOffset).append(this.startOffset).append(this.endOffset).append(this.timeOfStart).append(this.timeOfEnd).toHashCode();
    }

    public String toString() {
        return "LogicQueueMappingItem{gen=" + this.gen + ", queueId=" + this.queueId + ", bname='" + this.bname + '\'' + ", logicOffset=" + this.logicOffset + ", startOffset=" + this.startOffset + ", endOffset=" + this.endOffset + ", timeOfStart=" + this.timeOfStart + ", timeOfEnd=" + this.timeOfEnd + '}';
    }
}

