/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleUpDownCounterBuilder;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.LongUpDownCounterBuilder;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrumentBuilder;
import io.opentelemetry.sdk.metrics.InstrumentType;
import io.opentelemetry.sdk.metrics.InstrumentValueType;
import io.opentelemetry.sdk.metrics.SdkDoubleUpDownCounter;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.state.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.internal.state.MeterSharedState;
import io.opentelemetry.sdk.metrics.internal.state.WriteableMetricStorage;
import java.util.function.Consumer;

final class SdkLongUpDownCounter
extends AbstractInstrument
implements LongUpDownCounter {
    private final WriteableMetricStorage storage;

    private SdkLongUpDownCounter(InstrumentDescriptor descriptor, WriteableMetricStorage storage) {
        super(descriptor);
        this.storage = storage;
    }

    @Override
    public void add(long increment, Attributes attributes, Context context) {
        this.storage.recordLong(increment, attributes, context);
    }

    @Override
    public void add(long increment, Attributes attributes) {
        this.add(increment, attributes, Context.current());
    }

    @Override
    public void add(long increment) {
        this.add(increment, Attributes.empty());
    }

    static final class SdkLongUpDownCounterBuilder
    extends AbstractInstrumentBuilder<SdkLongUpDownCounterBuilder>
    implements LongUpDownCounterBuilder {
        SdkLongUpDownCounterBuilder(MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, String name) {
            super(meterProviderSharedState, meterSharedState, InstrumentType.UP_DOWN_COUNTER, InstrumentValueType.LONG, name, "", "");
        }

        @Override
        protected SdkLongUpDownCounterBuilder getThis() {
            return this;
        }

        @Override
        public LongUpDownCounter build() {
            return this.buildSynchronousInstrument((x$0, x$1) -> new SdkLongUpDownCounter((InstrumentDescriptor)x$0, (WriteableMetricStorage)x$1));
        }

        @Override
        public DoubleUpDownCounterBuilder ofDoubles() {
            return this.swapBuilder(SdkDoubleUpDownCounter.SdkDoubleUpDownCounterBuilder::new);
        }

        @Override
        public ObservableLongUpDownCounter buildWithCallback(Consumer<ObservableLongMeasurement> callback) {
            return this.registerLongAsynchronousInstrument(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER, callback);
        }

        @Override
        public ObservableLongMeasurement buildObserver() {
            return this.buildObservableMeasurement(InstrumentType.OBSERVABLE_UP_DOWN_COUNTER);
        }
    }
}

