/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.client.impl;

import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.client.impl.factory.MQClientInstance;
import org.apache.rocketmq.client.impl.producer.MQProducerInner;
import org.apache.rocketmq.client.producer.RequestFutureHolder;
import org.apache.rocketmq.client.producer.RequestResponseFuture;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.compression.Compressor;
import org.apache.rocketmq.common.compression.CompressorFactory;
import org.apache.rocketmq.common.message.MessageAccessor;
import org.apache.rocketmq.common.message.MessageDecoder;
import org.apache.rocketmq.common.message.MessageExt;
import org.apache.rocketmq.common.message.MessageQueue;
import org.apache.rocketmq.common.sysflag.MessageSysFlag;
import org.apache.rocketmq.common.utils.NetworkUtil;
import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.exception.RemotingCommandException;
import org.apache.rocketmq.remoting.netty.NettyRequestProcessor;
import org.apache.rocketmq.remoting.protocol.NamespaceUtil;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.body.ConsumeMessageDirectlyResult;
import org.apache.rocketmq.remoting.protocol.body.ConsumerRunningInfo;
import org.apache.rocketmq.remoting.protocol.body.GetConsumerStatusBody;
import org.apache.rocketmq.remoting.protocol.body.ResetOffsetBody;
import org.apache.rocketmq.remoting.protocol.header.CheckTransactionStateRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ConsumeMessageDirectlyResultRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerRunningInfoRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.GetConsumerStatusRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.NotifyConsumerIdsChangedRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ReplyMessageRequestHeader;
import org.apache.rocketmq.remoting.protocol.header.ResetOffsetRequestHeader;

public class ClientRemotingProcessor
implements NettyRequestProcessor {
    private final Logger logger = LoggerFactory.getLogger(ClientRemotingProcessor.class);
    private final MQClientInstance mqClientFactory;

    public ClientRemotingProcessor(MQClientInstance mqClientFactory) {
        this.mqClientFactory = mqClientFactory;
    }

    @Override
    public RemotingCommand processRequest(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        switch (request.getCode()) {
            case 39: {
                return this.checkTransactionState(ctx, request);
            }
            case 40: {
                return this.notifyConsumerIdsChanged(ctx, request);
            }
            case 220: {
                return this.resetOffset(ctx, request);
            }
            case 221: {
                return this.getConsumeStatus(ctx, request);
            }
            case 307: {
                return this.getConsumerRunningInfo(ctx, request);
            }
            case 309: {
                return this.consumeMessageDirectly(ctx, request);
            }
            case 326: {
                return this.receiveReplyMessage(ctx, request);
            }
        }
        return null;
    }

    @Override
    public boolean rejectRequest() {
        return false;
    }

    public RemotingCommand checkTransactionState(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        CheckTransactionStateRequestHeader requestHeader = request.decodeCommandCustomHeader(CheckTransactionStateRequestHeader.class);
        ByteBuffer byteBuffer = ByteBuffer.wrap(request.getBody());
        MessageExt messageExt = MessageDecoder.decode(byteBuffer);
        if (messageExt != null) {
            String group;
            String transactionId;
            if (StringUtils.isNotEmpty(this.mqClientFactory.getClientConfig().getNamespace())) {
                messageExt.setTopic(NamespaceUtil.withoutNamespace(messageExt.getTopic(), this.mqClientFactory.getClientConfig().getNamespace()));
            }
            if (null != (transactionId = messageExt.getProperty("UNIQ_KEY")) && !"".equals(transactionId)) {
                messageExt.setTransactionId(transactionId);
            }
            if ((group = messageExt.getProperty("PGROUP")) != null) {
                MQProducerInner producer = this.mqClientFactory.selectProducer(group);
                if (producer != null) {
                    String addr = RemotingHelper.parseChannelRemoteAddr(ctx.channel());
                    producer.checkTransactionState(addr, messageExt, requestHeader);
                } else {
                    this.logger.debug("checkTransactionState, pick producer by group[{}] failed", (Object)group);
                }
            } else {
                this.logger.warn("checkTransactionState, pick producer group failed");
            }
        } else {
            this.logger.warn("checkTransactionState, decode message failed");
        }
        return null;
    }

    public RemotingCommand notifyConsumerIdsChanged(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        try {
            NotifyConsumerIdsChangedRequestHeader requestHeader = request.decodeCommandCustomHeader(NotifyConsumerIdsChangedRequestHeader.class);
            this.logger.info("receive broker's notification[{}], the consumer group: {} changed, rebalance immediately", (Object)RemotingHelper.parseChannelRemoteAddr(ctx.channel()), (Object)requestHeader.getConsumerGroup());
            this.mqClientFactory.rebalanceImmediately();
        }
        catch (Exception e) {
            this.logger.error("notifyConsumerIdsChanged exception", (Object)UtilAll.exceptionSimpleDesc(e));
        }
        return null;
    }

    public RemotingCommand resetOffset(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        ResetOffsetRequestHeader requestHeader = request.decodeCommandCustomHeader(ResetOffsetRequestHeader.class);
        this.logger.info("invoke reset offset operation from broker. brokerAddr={}, topic={}, group={}, timestamp={}", RemotingHelper.parseChannelRemoteAddr(ctx.channel()), requestHeader.getTopic(), requestHeader.getGroup(), requestHeader.getTimestamp());
        Map<MessageQueue, Long> offsetTable = new HashMap<MessageQueue, Long>();
        if (request.getBody() != null) {
            ResetOffsetBody body = ResetOffsetBody.decode(request.getBody(), ResetOffsetBody.class);
            offsetTable = body.getOffsetTable();
        }
        this.mqClientFactory.resetOffset(requestHeader.getTopic(), requestHeader.getGroup(), offsetTable);
        return null;
    }

    @Deprecated
    public RemotingCommand getConsumeStatus(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumerStatusRequestHeader requestHeader = request.decodeCommandCustomHeader(GetConsumerStatusRequestHeader.class);
        Map<MessageQueue, Long> offsetTable = this.mqClientFactory.getConsumerStatus(requestHeader.getTopic(), requestHeader.getGroup());
        GetConsumerStatusBody body = new GetConsumerStatusBody();
        body.setMessageQueueTable(offsetTable);
        response.setBody(body.encode());
        response.setCode(0);
        return response;
    }

    private RemotingCommand getConsumerRunningInfo(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        GetConsumerRunningInfoRequestHeader requestHeader = request.decodeCommandCustomHeader(GetConsumerRunningInfoRequestHeader.class);
        ConsumerRunningInfo consumerRunningInfo = this.mqClientFactory.consumerRunningInfo(requestHeader.getConsumerGroup());
        if (null != consumerRunningInfo) {
            if (requestHeader.isJstackEnable()) {
                Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
                String jstack = UtilAll.jstack(map);
                consumerRunningInfo.setJstack(jstack);
            }
            response.setCode(0);
            response.setBody(consumerRunningInfo.encode());
        } else {
            response.setCode(1);
            response.setRemark(String.format("The Consumer Group <%s> not exist in this consumer", requestHeader.getConsumerGroup()));
        }
        return response;
    }

    private RemotingCommand consumeMessageDirectly(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        ConsumeMessageDirectlyResultRequestHeader requestHeader = request.decodeCommandCustomHeader(ConsumeMessageDirectlyResultRequestHeader.class);
        MessageExt msg = MessageDecoder.clientDecode(ByteBuffer.wrap(request.getBody()), true);
        ConsumeMessageDirectlyResult result = this.mqClientFactory.consumeMessageDirectly(msg, requestHeader.getConsumerGroup(), requestHeader.getBrokerName());
        if (null != result) {
            response.setCode(0);
            response.setBody(result.encode());
        } else {
            response.setCode(1);
            response.setRemark(String.format("The Consumer Group <%s> not exist in this consumer", requestHeader.getConsumerGroup()));
        }
        return response;
    }

    private RemotingCommand receiveReplyMessage(ChannelHandlerContext ctx, RemotingCommand request) throws RemotingCommandException {
        RemotingCommand response = RemotingCommand.createResponseCommand(null);
        long receiveTime = System.currentTimeMillis();
        ReplyMessageRequestHeader requestHeader = request.decodeCommandCustomHeader(ReplyMessageRequestHeader.class);
        try {
            MessageExt msg = new MessageExt();
            msg.setTopic(requestHeader.getTopic());
            msg.setQueueId(requestHeader.getQueueId());
            msg.setStoreTimestamp(requestHeader.getStoreTimestamp());
            if (requestHeader.getBornHost() != null) {
                msg.setBornHost(NetworkUtil.string2SocketAddress(requestHeader.getBornHost()));
            }
            if (requestHeader.getStoreHost() != null) {
                msg.setStoreHost(NetworkUtil.string2SocketAddress(requestHeader.getStoreHost()));
            }
            byte[] body = request.getBody();
            int sysFlag = requestHeader.getSysFlag();
            if ((sysFlag & 1) == 1) {
                try {
                    Compressor compressor = CompressorFactory.getCompressor(MessageSysFlag.getCompressionType(sysFlag));
                    body = compressor.decompress(body);
                }
                catch (IOException e) {
                    this.logger.warn("err when uncompress constant", e);
                }
            }
            msg.setBody(body);
            msg.setFlag(requestHeader.getFlag());
            MessageAccessor.setProperties(msg, MessageDecoder.string2messageProperties(requestHeader.getProperties()));
            MessageAccessor.putProperty(msg, "ARRIVE_TIME", String.valueOf(receiveTime));
            msg.setBornTimestamp(requestHeader.getBornTimestamp());
            msg.setReconsumeTimes(requestHeader.getReconsumeTimes() == null ? 0 : requestHeader.getReconsumeTimes());
            this.logger.debug("receive reply message :{}", (Object)msg);
            this.processReplyMessage(msg);
            response.setCode(0);
            response.setRemark(null);
        }
        catch (Exception e) {
            this.logger.warn("unknown err when receiveReplyMsg", e);
            response.setCode(1);
            response.setRemark("process reply message fail");
        }
        return response;
    }

    private void processReplyMessage(MessageExt replyMsg) {
        String correlationId = replyMsg.getUserProperty("CORRELATION_ID");
        RequestResponseFuture requestResponseFuture = RequestFutureHolder.getInstance().getRequestFutureTable().get(correlationId);
        if (requestResponseFuture != null) {
            requestResponseFuture.putResponseMessage(replyMsg);
            RequestFutureHolder.getInstance().getRequestFutureTable().remove(correlationId);
            if (requestResponseFuture.getRequestCallback() != null) {
                requestResponseFuture.getRequestCallback().onSuccess(replyMsg);
            }
        } else {
            String bornHost = replyMsg.getBornHostString();
            this.logger.warn("receive reply message, but not matched any request, CorrelationId: {} , reply from host: {}", (Object)correlationId, (Object)bornHost);
        }
    }
}

