/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.config;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.common.config.AbstractRocksDBStorage;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactRangeOptions;
import org.rocksdb.CompactionOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.DataBlockIndexType;
import org.rocksdb.IndexType;
import org.rocksdb.InfoLogLevel;
import org.rocksdb.LRUCache;
import org.rocksdb.RateLimiter;
import org.rocksdb.ReadOptions;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;
import org.rocksdb.SkipListMemTableConfig;
import org.rocksdb.Statistics;
import org.rocksdb.StatsLevel;
import org.rocksdb.StringAppendOperator;
import org.rocksdb.WALRecoveryMode;
import org.rocksdb.WriteBatch;
import org.rocksdb.WriteOptions;

public class ConfigRocksDBStorage
extends AbstractRocksDBStorage {
    public ConfigRocksDBStorage(String dbPath) {
        this.dbPath = dbPath;
        this.readOnly = false;
    }

    public ConfigRocksDBStorage(String dbPath, boolean readOnly) {
        this.dbPath = dbPath;
        this.readOnly = readOnly;
    }

    private void initOptions() {
        this.options = this.createConfigDBOptions();
        this.writeOptions = new WriteOptions();
        this.writeOptions.setSync(false);
        this.writeOptions.setDisableWAL(true);
        this.writeOptions.setNoSlowdown(true);
        this.ableWalWriteOptions = new WriteOptions();
        this.ableWalWriteOptions.setSync(false);
        this.ableWalWriteOptions.setDisableWAL(false);
        this.ableWalWriteOptions.setNoSlowdown(true);
        this.readOptions = new ReadOptions();
        this.readOptions.setPrefixSameAsStart(true);
        this.readOptions.setTotalOrderSeek(false);
        this.readOptions.setTailing(false);
        this.totalOrderReadOptions = new ReadOptions();
        this.totalOrderReadOptions.setPrefixSameAsStart(false);
        this.totalOrderReadOptions.setTotalOrderSeek(false);
        this.totalOrderReadOptions.setTailing(false);
        this.compactRangeOptions = new CompactRangeOptions();
        this.compactRangeOptions.setBottommostLevelCompaction(CompactRangeOptions.BottommostLevelCompaction.kForce);
        this.compactRangeOptions.setAllowWriteStall(true);
        this.compactRangeOptions.setExclusiveManualCompaction(false);
        this.compactRangeOptions.setChangeLevel(true);
        this.compactRangeOptions.setTargetLevel(-1);
        this.compactRangeOptions.setMaxSubcompactions(4);
        this.compactionOptions = new CompactionOptions();
        this.compactionOptions.setCompression(CompressionType.LZ4_COMPRESSION);
        this.compactionOptions.setMaxSubcompactions(4);
        this.compactionOptions.setOutputFileSizeLimit(0x100000000L);
    }

    @Override
    protected boolean postLoad() {
        try {
            UtilAll.ensureDirOK(this.dbPath);
            this.initOptions();
            ArrayList<ColumnFamilyDescriptor> cfDescriptors = new ArrayList<ColumnFamilyDescriptor>();
            ColumnFamilyOptions defaultOptions = this.createConfigOptions();
            this.cfOptions.add(defaultOptions);
            cfDescriptors.add(new ColumnFamilyDescriptor(RocksDB.DEFAULT_COLUMN_FAMILY, defaultOptions));
            ArrayList<ColumnFamilyHandle> cfHandles = new ArrayList<ColumnFamilyHandle>();
            this.open(cfDescriptors, cfHandles);
            this.defaultCFHandle = (ColumnFamilyHandle)cfHandles.get(0);
        }
        catch (Exception e) {
            AbstractRocksDBStorage.LOGGER.error("postLoad Failed. {}", (Object)this.dbPath, (Object)e);
            return false;
        }
        return true;
    }

    @Override
    protected void preShutdown() {
    }

    private ColumnFamilyOptions createConfigOptions() {
        BlockBasedTableConfig blockBasedTableConfig = new BlockBasedTableConfig().setFormatVersion(5).setIndexType(IndexType.kBinarySearch).setDataBlockIndexType(DataBlockIndexType.kDataBlockBinarySearch).setBlockSize(32768L).setFilterPolicy(new BloomFilter(16.0, false)).setCacheIndexAndFilterBlocks(false).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(false).setPinTopLevelIndexAndFilter(true).setBlockCache(new LRUCache(0x400000L, 8, false)).setWholeKeyFiltering(true);
        ColumnFamilyOptions options = new ColumnFamilyOptions();
        return options.setMaxWriteBufferNumber(2).setWriteBufferSize(0x800000L).setMinWriteBufferNumberToMerge(1).setTableFormatConfig(blockBasedTableConfig).setMemTableConfig(new SkipListMemTableConfig()).setCompressionType(CompressionType.NO_COMPRESSION).setNumLevels(7).setCompactionStyle(CompactionStyle.LEVEL).setLevel0FileNumCompactionTrigger(4).setLevel0SlowdownWritesTrigger(8).setLevel0StopWritesTrigger(12).setTargetFileSizeBase(0x4000000L).setTargetFileSizeMultiplier(2).setMaxBytesForLevelBase(0x10000000L).setMaxBytesForLevelMultiplier(2.0).setMergeOperator(new StringAppendOperator()).setInplaceUpdateSupport(true);
    }

    private DBOptions createConfigDBOptions() {
        DBOptions options = new DBOptions();
        Statistics statistics = new Statistics();
        statistics.setStatsLevel(StatsLevel.EXCEPT_DETAILED_TIMERS);
        return options.setDbLogDir(ConfigRocksDBStorage.getDBLogDir()).setInfoLogLevel(InfoLogLevel.INFO_LEVEL).setWalRecoveryMode(WALRecoveryMode.SkipAnyCorruptedRecords).setManualWalFlush(true).setMaxTotalWalSize(524288000L).setWalSizeLimitMB(0L).setWalTtlSeconds(0L).setCreateIfMissing(true).setCreateMissingColumnFamilies(true).setMaxOpenFiles(-1).setMaxLogFileSize(0x40000000L).setKeepLogFileNum(5L).setMaxManifestFileSize(0x40000000L).setAllowConcurrentMemtableWrite(false).setStatistics(statistics).setStatsDumpPeriodSec(600).setAtomicFlush(true).setMaxBackgroundJobs(32).setMaxSubcompactions(4).setParanoidChecks(true).setDelayedWriteRate(0x1000000L).setRateLimiter(new RateLimiter(0x6400000L)).setUseDirectIoForFlushAndCompaction(true).setUseDirectReads(true);
    }

    public static String getDBLogDir() {
        String rootPath = System.getProperty("user.home");
        if (StringUtils.isEmpty(rootPath)) {
            return "";
        }
        rootPath = rootPath + File.separator + "logs";
        UtilAll.ensureDirOK(rootPath);
        return rootPath + File.separator + "rocketmqlogs" + File.separator;
    }

    public void put(byte[] keyBytes, int keyLen, byte[] valueBytes) throws Exception {
        this.put(this.defaultCFHandle, this.ableWalWriteOptions, keyBytes, keyLen, valueBytes, valueBytes.length);
    }

    public void put(ByteBuffer keyBB, ByteBuffer valueBB) throws Exception {
        this.put(this.defaultCFHandle, this.ableWalWriteOptions, keyBB, valueBB);
    }

    public byte[] get(byte[] keyBytes) throws Exception {
        return this.get(this.defaultCFHandle, this.totalOrderReadOptions, keyBytes);
    }

    public void delete(byte[] keyBytes) throws Exception {
        this.delete(this.defaultCFHandle, this.ableWalWriteOptions, keyBytes);
    }

    public List<byte[]> multiGet(List<ColumnFamilyHandle> cfhList, List<byte[]> keys2) throws RocksDBException {
        return this.multiGet(this.totalOrderReadOptions, cfhList, keys2);
    }

    public void batchPut(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.writeOptions, batch);
    }

    public void batchPutWithWal(WriteBatch batch) throws RocksDBException {
        this.batchPut(this.ableWalWriteOptions, batch);
    }

    public RocksIterator iterator() {
        return this.db.newIterator(this.defaultCFHandle, this.totalOrderReadOptions);
    }

    public void rangeDelete(byte[] startKey, byte[] endKey) throws RocksDBException {
        this.rangeDelete(this.defaultCFHandle, this.writeOptions, startKey, endKey);
    }

    public RocksIterator iterator(ReadOptions readOptions) {
        return this.db.newIterator(this.defaultCFHandle, readOptions);
    }
}

