/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.common.resource;

import com.alibaba.fastjson2.annotation.JSONField;
import org.apache.commons.lang3.StringUtils;

public enum ResourceType {
    UNKNOWN(0, "Unknown"),
    ANY(1, "Any"),
    CLUSTER(2, "Cluster"),
    NAMESPACE(3, "Namespace"),
    TOPIC(4, "Topic"),
    GROUP(5, "Group");

    @JSONField(value=true)
    private final byte code;
    private final String name;

    private ResourceType(byte code, String name) {
        this.code = code;
        this.name = name;
    }

    public static ResourceType getByName(String name) {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!StringUtils.equalsIgnoreCase(resourceType.getName(), name)) continue;
            return resourceType;
        }
        return null;
    }

    public byte getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }
}

