/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.logging.ch.qos.logback.core.util;

import java.io.PrintStream;
import java.util.Iterator;
import java.util.List;
import org.apache.rocketmq.logging.ch.qos.logback.core.Context;
import org.apache.rocketmq.logging.ch.qos.logback.core.CoreConstants;
import org.apache.rocketmq.logging.ch.qos.logback.core.helpers.ThrowableToStringArray;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.Status;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.StatusManager;
import org.apache.rocketmq.logging.ch.qos.logback.core.status.StatusUtil;
import org.apache.rocketmq.logging.ch.qos.logback.core.util.CachingDateFormatter;

public class StatusPrinter {
    private static PrintStream ps = System.out;
    static CachingDateFormatter cachingDateFormat = new CachingDateFormatter("HH:mm:ss,SSS");

    public static void setPrintStream(PrintStream printStream) {
        ps = printStream;
    }

    public static void printInCaseOfErrorsOrWarnings(Context context) {
        StatusPrinter.printInCaseOfErrorsOrWarnings(context, 0L);
    }

    public static void printInCaseOfErrorsOrWarnings(Context context, long threshold) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(threshold) >= 1) {
                StatusPrinter.print(sm, threshold);
            }
        }
    }

    public static void printIfErrorsOccured(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusUtil statusUtil = new StatusUtil(context);
            if (statusUtil.getHighestLevel(0L) == 2) {
                StatusPrinter.print(sm);
            }
        }
    }

    public static void print(Context context) {
        StatusPrinter.print(context, 0L);
    }

    public static void print(Context context, long threshold) {
        if (context == null) {
            throw new IllegalArgumentException("Context argument cannot be null");
        }
        StatusManager sm = context.getStatusManager();
        if (sm == null) {
            ps.println("WARN: Context named \"" + context.getName() + "\" has no status manager");
        } else {
            StatusPrinter.print(sm, threshold);
        }
    }

    public static void print(StatusManager sm) {
        StatusPrinter.print(sm, 0L);
    }

    public static void print(StatusManager sm, long threshold) {
        StringBuilder sb = new StringBuilder();
        List<Status> filteredList = StatusUtil.filterStatusListByTimeThreshold(sm.getCopyOfStatusList(), threshold);
        StatusPrinter.buildStrFromStatusList(sb, filteredList);
        ps.println(sb.toString());
    }

    public static void print(List<Status> statusList) {
        StringBuilder sb = new StringBuilder();
        StatusPrinter.buildStrFromStatusList(sb, statusList);
        ps.println(sb.toString());
    }

    private static void buildStrFromStatusList(StringBuilder sb, List<Status> statusList) {
        if (statusList == null) {
            return;
        }
        for (Status s2 : statusList) {
            StatusPrinter.buildStr(sb, "", s2);
        }
    }

    private static void appendThrowable(StringBuilder sb, Throwable t2) {
        String[] stringRep;
        for (String s2 : stringRep = ThrowableToStringArray.convert(t2)) {
            if (!s2.startsWith("Caused by: ")) {
                if (Character.isDigit(s2.charAt(0))) {
                    sb.append("\t... ");
                } else {
                    sb.append("\tat ");
                }
            }
            sb.append(s2).append(CoreConstants.LINE_SEPARATOR);
        }
    }

    public static void buildStr(StringBuilder sb, String indentation, Status s2) {
        String prefix = s2.hasChildren() ? indentation + "+ " : indentation + "|-";
        if (cachingDateFormat != null) {
            String dateStr = cachingDateFormat.format(s2.getDate());
            sb.append(dateStr).append(" ");
        }
        sb.append(prefix).append(s2).append(CoreConstants.LINE_SEPARATOR);
        if (s2.getThrowable() != null) {
            StatusPrinter.appendThrowable(sb, s2.getThrowable());
        }
        if (s2.hasChildren()) {
            Iterator<Status> ite = s2.iterator();
            while (ite.hasNext()) {
                Status child = ite.next();
                StatusPrinter.buildStr(sb, indentation + "  ", child);
            }
        }
    }
}

