/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.remoting.protocol;

import org.apache.rocketmq.logging.org.slf4j.Logger;
import org.apache.rocketmq.logging.org.slf4j.LoggerFactory;
import org.apache.rocketmq.remoting.common.RemotingHelper;
import org.apache.rocketmq.remoting.protocol.RemotingCommand;
import org.apache.rocketmq.remoting.protocol.header.namesrv.RegisterBrokerRequestHeader;

public class MQProtosHelper {
    private static final Logger log = LoggerFactory.getLogger("RocketmqCommon");

    public static boolean registerBrokerToNameServer(String nsaddr, String brokerAddr, long timeoutMillis) {
        RegisterBrokerRequestHeader requestHeader = new RegisterBrokerRequestHeader();
        requestHeader.setBrokerAddr(brokerAddr);
        RemotingCommand request = RemotingCommand.createRequestCommand(103, requestHeader);
        try {
            RemotingCommand response = RemotingHelper.invokeSync(nsaddr, request, timeoutMillis);
            if (response != null) {
                return 0 == response.getCode();
            }
        }
        catch (Exception e) {
            log.error("Failed to register broker", e);
        }
        return false;
    }
}

