/*
 * Decompiled with CFR 0.152.
 */
package org.awaitility.core;

import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.DoubleAccumulator;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAccumulator;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Function;
import java.util.function.Predicate;
import org.awaitility.constraint.AtMostWaitConstraint;
import org.awaitility.constraint.WaitConstraint;
import org.awaitility.core.AssertionCondition;
import org.awaitility.core.CallableCondition;
import org.awaitility.core.CallableHamcrestCondition;
import org.awaitility.core.Condition;
import org.awaitility.core.ConditionEvaluationListener;
import org.awaitility.core.ConditionSettings;
import org.awaitility.core.DurationFactory;
import org.awaitility.core.ExceptionIgnorer;
import org.awaitility.core.ExecutorLifecycle;
import org.awaitility.core.FailFastCondition;
import org.awaitility.core.ForeverDuration;
import org.awaitility.core.HamcrestExceptionIgnorer;
import org.awaitility.core.InternalExecutorServiceFactory;
import org.awaitility.core.PredicateExceptionIgnorer;
import org.awaitility.core.TemporalDuration;
import org.awaitility.core.ThrowingRunnable;
import org.awaitility.pollinterval.FixedPollInterval;
import org.awaitility.pollinterval.PollInterval;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeMatcher;

public class ConditionFactory {
    private final WaitConstraint timeoutConstraint;
    private final PollInterval pollInterval;
    private final boolean catchUncaughtExceptions;
    private final ExceptionIgnorer exceptionsIgnorer;
    private final String alias;
    private final Duration pollDelay;
    private final ConditionEvaluationListener conditionEvaluationListener;
    private final ExecutorLifecycle executorLifecycle;
    private final FailFastCondition failFastCondition;

    public ConditionFactory(String alias, WaitConstraint timeoutConstraint, PollInterval pollInterval, Duration pollDelay, boolean catchUncaughtExceptions, ExceptionIgnorer exceptionsIgnorer, ConditionEvaluationListener conditionEvaluationListener, ExecutorLifecycle executorLifecycle, FailFastCondition failFastCondition) {
        if (pollInterval == null) {
            throw new IllegalArgumentException("pollInterval cannot be null");
        }
        if (timeoutConstraint == null) {
            throw new IllegalArgumentException("timeout cannot be null");
        }
        this.alias = alias;
        this.timeoutConstraint = timeoutConstraint;
        this.pollInterval = pollInterval;
        this.catchUncaughtExceptions = catchUncaughtExceptions;
        this.pollDelay = pollDelay;
        this.conditionEvaluationListener = conditionEvaluationListener;
        this.exceptionsIgnorer = exceptionsIgnorer;
        this.executorLifecycle = executorLifecycle;
        this.failFastCondition = failFastCondition;
    }

    public ConditionFactory conditionEvaluationListener(ConditionEvaluationListener conditionEvaluationListener) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory timeout(Duration timeout2) {
        return this.atMost(timeout2);
    }

    public ConditionFactory atMost(Duration timeout2) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withMaxWaitTime(timeout2), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory during(Duration timeout2) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withHoldPredicateTime(timeout2), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory during(long timeout2, TimeUnit unit) {
        return this.during(DurationFactory.of(timeout2, unit));
    }

    public ConditionFactory alias(String alias) {
        return new ConditionFactory(alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory atLeast(Duration timeout2) {
        return new ConditionFactory(this.alias, this.timeoutConstraint.withMinWaitTime(timeout2), this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory atLeast(long timeout2, TimeUnit unit) {
        return this.atLeast(DurationFactory.of(timeout2, unit));
    }

    public ConditionFactory between(Duration atLeast, Duration atMost) {
        return this.atLeast(atLeast).and().atMost(atMost);
    }

    public ConditionFactory between(long atLeastDuration, TimeUnit atLeastTimeUnit, long atMostDuration, TimeUnit atMostTimeUnit) {
        return this.between(DurationFactory.of(atLeastDuration, atLeastTimeUnit), DurationFactory.of(atMostDuration, atMostTimeUnit));
    }

    public ConditionFactory forever() {
        return new ConditionFactory(this.alias, AtMostWaitConstraint.FOREVER, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory pollInterval(Duration pollInterval) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, new FixedPollInterval(pollInterval), this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory timeout(long timeout2, TimeUnit unit) {
        return this.atMost(timeout2, unit);
    }

    public ConditionFactory pollDelay(long delay, TimeUnit unit) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, DurationFactory.of(delay, unit), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory pollDelay(Duration pollDelay) {
        if (pollDelay == null) {
            throw new IllegalArgumentException("pollDelay cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory atMost(long timeout2, TimeUnit unit) {
        return this.atMost(DurationFactory.of(timeout2, unit));
    }

    public ConditionFactory pollInterval(long pollInterval, TimeUnit unit) {
        FixedPollInterval fixedPollInterval = new FixedPollInterval(DurationFactory.of(pollInterval, unit));
        return new ConditionFactory(this.alias, this.timeoutConstraint, fixedPollInterval, this.definePollDelay(this.pollDelay, fixedPollInterval), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory pollInterval(PollInterval pollInterval) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, pollInterval, this.definePollDelay(this.pollDelay, pollInterval), this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory catchUncaughtExceptions() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, true, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory ignoreExceptionsInstanceOf(Class<? extends Throwable> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exceptionType cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(e -> exceptionType.isAssignableFrom(e.getClass())), this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory ignoreException(Class<? extends Throwable> exceptionType) {
        if (exceptionType == null) {
            throw new IllegalArgumentException("exception cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(e -> e.getClass().equals(exceptionType)), this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory ignoreExceptions() {
        return this.ignoreExceptionsMatching((? super Throwable e) -> true);
    }

    public ConditionFactory ignoreNoExceptions() {
        return this.ignoreExceptionsMatching((? super Throwable e) -> false);
    }

    public ConditionFactory ignoreExceptionsMatching(Matcher<? super Throwable> matcher) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new HamcrestExceptionIgnorer(matcher), this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory ignoreExceptionsMatching(Predicate<? super Throwable> predicate) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, new PredicateExceptionIgnorer(predicate), this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory await() {
        return this;
    }

    public ConditionFactory await(String alias) {
        return new ConditionFactory(alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory and() {
        return this;
    }

    public ConditionFactory with() {
        return this;
    }

    public ConditionFactory then() {
        return this;
    }

    public ConditionFactory given() {
        return this;
    }

    public ConditionFactory dontCatchUncaughtExceptions() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, this.failFastCondition);
    }

    public ConditionFactory pollExecutorService(ExecutorService executorService) {
        if (executorService instanceof ScheduledExecutorService) {
            throw new IllegalArgumentException("Poll executor service cannot be an instance of " + ScheduledExecutorService.class.getName());
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, ExecutorLifecycle.withoutCleanup(executorService), this.failFastCondition);
    }

    public ConditionFactory pollThread(Function<Runnable, Thread> threadSupplier) {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, ExecutorLifecycle.withNormalCleanupBehavior(() -> InternalExecutorServiceFactory.create(threadSupplier)), this.failFastCondition);
    }

    public ConditionFactory pollInSameThread() {
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, false, this.exceptionsIgnorer, this.conditionEvaluationListener, ExecutorLifecycle.withNormalCleanupBehavior(InternalExecutorServiceFactory::sameThreadExecutorService), this.failFastCondition);
    }

    public ConditionFactory failFast(Callable<Boolean> failFastCondition) {
        if (failFastCondition == null) {
            throw new IllegalArgumentException("failFastCondition cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, new FailFastCondition(null, failFastCondition));
    }

    public ConditionFactory failFast(String failFastFailureReason, Callable<Boolean> failFastCondition) {
        if (failFastCondition == null) {
            throw new IllegalArgumentException("failFastCondition cannot be null");
        }
        if (failFastFailureReason == null) {
            throw new IllegalArgumentException("failFastFailureReason cannot be null");
        }
        return new ConditionFactory(this.alias, this.timeoutConstraint, this.pollInterval, this.pollDelay, this.catchUncaughtExceptions, this.exceptionsIgnorer, this.conditionEvaluationListener, this.executorLifecycle, new FailFastCondition(failFastFailureReason, failFastCondition));
    }

    public <T> T until(Callable<T> supplier, Matcher<? super T> matcher) {
        return this.until(new CallableHamcrestCondition<T>(supplier, matcher, this.generateConditionSettings()));
    }

    public <T> T until(Callable<T> supplier, final Predicate<? super T> predicate) {
        return this.until(supplier, new TypeSafeMatcher<T>(){

            @Override
            protected void describeMismatchSafely(T item, Description description) {
                description.appendText("it returned <false> for input of ").appendValue(item);
            }

            @Override
            public void describeTo(Description description) {
                description.appendText("the predicate to return <true>");
            }

            @Override
            protected boolean matchesSafely(T item) {
                return predicate.test(item);
            }
        });
    }

    public void untilAsserted(ThrowingRunnable assertion) {
        this.until(new AssertionCondition(assertion, this.generateConditionSettings()));
    }

    public Integer untilAtomic(final AtomicInteger atomic, Matcher<? super Integer> matcher) {
        return this.until(new CallableHamcrestCondition<Integer>(new Callable<Integer>(){

            @Override
            public Integer call() {
                return atomic.get();
            }
        }, matcher, this.generateConditionSettings()));
    }

    public Long untilAtomic(AtomicLong atomic, Matcher<? super Long> matcher) {
        return this.until(new CallableHamcrestCondition<Long>(atomic::get, matcher, this.generateConditionSettings()));
    }

    public void untilAtomic(AtomicBoolean atomic, Matcher<? super Boolean> matcher) {
        this.until(new CallableHamcrestCondition<Boolean>(atomic::get, matcher, this.generateConditionSettings()));
    }

    public void untilTrue(AtomicBoolean atomic) {
        this.untilAtomic(atomic, Matchers.anyOf(Matchers.is(Boolean.TRUE), Matchers.is(true)));
    }

    public void untilFalse(AtomicBoolean atomic) {
        this.untilAtomic(atomic, Matchers.anyOf(Matchers.is(Boolean.FALSE), Matchers.is(false)));
    }

    public void untilAdder(LongAdder adder, Matcher<? super Long> matcher) {
        this.until(new CallableHamcrestCondition<Long>(adder::longValue, matcher, this.generateConditionSettings()));
    }

    public void untilAdder(DoubleAdder adder, Matcher<? super Double> matcher) {
        this.until(new CallableHamcrestCondition<Double>(adder::doubleValue, matcher, this.generateConditionSettings()));
    }

    public void untilAccumulator(LongAccumulator accumulator, Matcher<? super Long> matcher) {
        this.until(new CallableHamcrestCondition<Long>(accumulator::longValue, matcher, this.generateConditionSettings()));
    }

    public void untilAccumulator(DoubleAccumulator accumulator, Matcher<? super Double> matcher) {
        this.until(new CallableHamcrestCondition<Double>(accumulator::doubleValue, matcher, this.generateConditionSettings()));
    }

    public <V> V untilAtomic(AtomicReference<V> atomic, Matcher<? super V> matcher) {
        return this.until(new CallableHamcrestCondition<V>(atomic::get, matcher, this.generateConditionSettings()));
    }

    public void until(Callable<Boolean> conditionEvaluator) {
        this.until(new CallableCondition(conditionEvaluator, this.generateConditionSettings()));
    }

    private ConditionSettings generateConditionSettings() {
        Duration actualPollDelay = this.definePollDelay(this.pollDelay, this.pollInterval);
        if (ForeverDuration.isForever(actualPollDelay)) {
            throw new IllegalArgumentException("Cannot delay polling forever");
        }
        Duration timeout2 = this.timeoutConstraint.getMaxWaitTime();
        if (!ForeverDuration.isForever(timeout2) && timeout2.toNanos() <= actualPollDelay.toNanos()) {
            throw new IllegalArgumentException(String.format("Timeout (%s) must be greater than the poll delay (%s).", TemporalDuration.formatAsString(timeout2), TemporalDuration.formatAsString(actualPollDelay)));
        }
        if (!ForeverDuration.isForever(actualPollDelay) && !ForeverDuration.isForever(timeout2) && timeout2.toNanos() <= actualPollDelay.toNanos()) {
            throw new IllegalArgumentException(String.format("Timeout (%s) must be greater than the poll delay (%s).", TemporalDuration.formatAsString(timeout2), TemporalDuration.formatAsString(actualPollDelay)));
        }
        ExecutorLifecycle executorLifecycle = this.executorLifecycle == null ? ExecutorLifecycle.withNormalCleanupBehavior(() -> InternalExecutorServiceFactory.create((r, threadName) -> new Thread(Thread.currentThread().getThreadGroup(), (Runnable)r, (String)threadName), this.alias)) : this.executorLifecycle;
        return new ConditionSettings(this.alias, this.catchUncaughtExceptions, this.timeoutConstraint, this.pollInterval, actualPollDelay, this.conditionEvaluationListener, this.exceptionsIgnorer, executorLifecycle, this.failFastCondition);
    }

    private <T> T until(Condition<T> condition) {
        return condition.await();
    }

    private Duration definePollDelay(Duration pollDelay, PollInterval pollInterval) {
        Duration pollDelayToUse = pollDelay == null ? (pollInterval instanceof FixedPollInterval ? pollInterval.next(1, Duration.ZERO) : Duration.ZERO) : pollDelay;
        return pollDelayToUse;
    }
}

