/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import org.apache.camel.CamelContext;
import org.apache.camel.Processor;
import org.apache.camel.processor.saga.MandatorySagaProcessor;
import org.apache.camel.processor.saga.NeverSagaProcessor;
import org.apache.camel.processor.saga.NotSupportedSagaProcessor;
import org.apache.camel.processor.saga.RequiredSagaProcessor;
import org.apache.camel.processor.saga.RequiresNewSagaProcessor;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessor;
import org.apache.camel.processor.saga.SagaPropagation;
import org.apache.camel.processor.saga.SupportsSagaProcessor;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;

public class SagaProcessorBuilder {
    private CamelContext camelContext;
    private Processor childProcessor;
    private CamelSagaService sagaService;
    private CamelSagaStep step;
    private SagaPropagation propagation;
    private SagaCompletionMode completionMode;

    public SagaProcessorBuilder camelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        return this;
    }

    public SagaProcessorBuilder childProcessor(Processor childProcessor) {
        this.childProcessor = childProcessor;
        return this;
    }

    public SagaProcessorBuilder sagaService(CamelSagaService sagaService) {
        this.sagaService = sagaService;
        return this;
    }

    public SagaProcessorBuilder step(CamelSagaStep step) {
        this.step = step;
        return this;
    }

    public SagaProcessorBuilder propagation(SagaPropagation propagation) {
        this.propagation = propagation;
        return this;
    }

    public SagaProcessorBuilder completionMode(SagaCompletionMode completionMode) {
        this.completionMode = completionMode;
        return this;
    }

    public SagaProcessor build() {
        if (this.propagation == null) {
            throw new IllegalStateException("A propagation mode has not been set");
        }
        switch (this.propagation) {
            case REQUIRED: {
                return new RequiredSagaProcessor(this.camelContext, this.childProcessor, this.sagaService, this.completionMode, this.step);
            }
            case REQUIRES_NEW: {
                return new RequiresNewSagaProcessor(this.camelContext, this.childProcessor, this.sagaService, this.completionMode, this.step);
            }
            case SUPPORTS: {
                return new SupportsSagaProcessor(this.camelContext, this.childProcessor, this.sagaService, this.completionMode, this.step);
            }
            case NOT_SUPPORTED: {
                return new NotSupportedSagaProcessor(this.camelContext, this.childProcessor, this.sagaService, this.completionMode, this.step);
            }
            case NEVER: {
                return new NeverSagaProcessor(this.camelContext, this.childProcessor, this.sagaService, this.completionMode, this.step);
            }
            case MANDATORY: {
                return new MandatorySagaProcessor(this.camelContext, this.childProcessor, this.sagaService, this.completionMode, this.step);
            }
        }
        throw new IllegalStateException("Unsupported propagation mode: " + this.propagation);
    }
}

