/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sap.netweaver;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.component.sap.netweaver.NetWeaverEndpoint;
import org.apache.camel.support.DefaultProducer;
import org.apache.camel.support.ExchangeHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.URISupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetWeaverProducer
extends DefaultProducer {
    private static final Logger LOG = LoggerFactory.getLogger(NetWeaverProducer.class);
    private Producer http;

    public NetWeaverProducer(Endpoint endpoint) {
        super(endpoint);
    }

    @Override
    public NetWeaverEndpoint getEndpoint() {
        return (NetWeaverEndpoint)super.getEndpoint();
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        String command = ExchangeHelper.getMandatoryHeader(exchange, "CamelNetWeaverCommand", String.class);
        Exchange httpExchange = this.getEndpoint().createExchange();
        httpExchange.getIn().setHeader("CamelHttpPath", command);
        if (this.getEndpoint().isJson()) {
            httpExchange.getIn().setHeader("Accept", "application/json");
        }
        LOG.debug("Calling SAP Net-Weaver {} with command {}", (Object)this.http, (Object)command);
        this.http.process(httpExchange);
        String data = httpExchange.getOut().getBody(String.class);
        if (data != null && this.getEndpoint().isJsonAsMap() && this.getEndpoint().isJson()) {
            ObjectMapper mapper = new ObjectMapper();
            Map map = mapper.readValue(data, Map.class);
            if (map.size() == 1 && this.getEndpoint().isFlatternMap()) {
                exchange.getIn().setBody(map.values().iterator().next());
            } else {
                exchange.getIn().setBody(map);
            }
        } else {
            exchange.getIn().setBody(data);
        }
    }

    @Override
    protected void doStart() throws Exception {
        String url = this.getEndpoint().getUrl() + "?authUsername=" + this.getEndpoint().getUsername() + "&authPassword=" + this.getEndpoint().getPassword() + "&authMethod=Basic";
        if (LOG.isInfoEnabled()) {
            LOG.info("Creating NetWeaverProducer using url: {}", (Object)URISupport.sanitizeUri(url));
        }
        this.http = this.getEndpoint().getCamelContext().getEndpoint(url).createProducer();
        ServiceHelper.startService(this.http);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.http);
    }
}

