/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.http;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.http.HttpEndpoint;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.spi.HeaderFilterStrategy;
import org.apache.camel.support.PollingConsumerSupport;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpUriRequest;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.protocol.HttpContext;

public class HttpPollingConsumer
extends PollingConsumerSupport {
    private final HttpEndpoint endpoint;
    private HttpClient httpClient;
    private final HttpContext httpContext;

    public HttpPollingConsumer(HttpEndpoint endpoint) {
        super(endpoint);
        this.endpoint = endpoint;
        this.httpContext = endpoint.getHttpContext();
        this.httpClient = endpoint.getHttpClient();
    }

    @Override
    public HttpEndpoint getEndpoint() {
        return (HttpEndpoint)super.getEndpoint();
    }

    @Override
    public Exchange receive() {
        return this.doReceive(-1);
    }

    @Override
    public Exchange receive(long timeout) {
        return this.doReceive((int)timeout);
    }

    @Override
    public Exchange receiveNoWait() {
        return this.doReceive(-1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Exchange doReceive(int timeout) {
        Exchange exchange;
        Exchange exchange2 = this.endpoint.createExchange();
        HttpUriRequest method = this.createMethod(exchange2);
        HttpClientContext httpClientContext = new HttpClientContext();
        if (timeout > 0) {
            RequestConfig requestConfig = RequestConfig.custom().setResponseTimeout(timeout, TimeUnit.MILLISECONDS).build();
            httpClientContext.setRequestConfig(requestConfig);
        }
        HttpEntity responseEntity = null;
        try {
            responseEntity = this.executeMethod(method, httpClientContext, response -> {
                int responseCode = response.getCode();
                HttpEntity entity = response.getEntity();
                Object body = HttpHelper.cacheResponseBodyFromInputStream(entity.getContent(), exchange2);
                Message message = exchange2.getMessage();
                message.setBody(body);
                Header[] headers = response.getHeaders();
                HeaderFilterStrategy strategy = this.endpoint.getHeaderFilterStrategy();
                for (Header header : headers) {
                    String name = header.getName();
                    if (name.equalsIgnoreCase("content-type")) {
                        name = "Content-Type";
                    }
                    String value = header.getValue();
                    if (strategy == null || strategy.applyFilterToExternalHeaders(name, value, exchange2)) continue;
                    message.setHeader(name, value);
                }
                message.setHeader("CamelHttpResponseCode", responseCode);
                if (response.getReasonPhrase() != null) {
                    message.setHeader("CamelHttpResponseText", response.getReasonPhrase());
                }
                return entity;
            });
            exchange = exchange2;
            if (responseEntity == null) return exchange;
        }
        catch (IOException e) {
            try {
                throw new RuntimeCamelException(e);
            }
            catch (Throwable throwable) {
                if (responseEntity == null) throw throwable;
                try {
                    EntityUtils.consume(responseEntity);
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            EntityUtils.consume(responseEntity);
            return exchange;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return exchange;
    }

    protected <T> T executeMethod(HttpUriRequest httpRequest, HttpClientContext httpClientContext, HttpClientResponseHandler<T> handler) throws IOException {
        if (this.httpContext != null) {
            httpClientContext = new HttpClientContext(this.httpContext);
        }
        return this.httpClient.execute(httpRequest, httpClientContext, handler);
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpUriRequest createMethod(Exchange exchange) {
        String uri = HttpHelper.createURL(exchange, this.endpoint);
        return new HttpGet(uri);
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

