/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpHelper;
import org.apache.camel.http.common.HttpMessage;
import org.apache.camel.http.common.HttpRegistryProvider;
import org.apache.camel.http.common.HttpServletResolveConsumerStrategy;
import org.apache.camel.http.common.ServletResolveConsumerStrategy;
import org.apache.camel.spi.ExecutorServiceManager;
import org.apache.camel.support.LifecycleStrategySupport;
import org.apache.camel.support.RestConsumerContextPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelServlet
extends HttpServlet
implements HttpRegistryProvider {
    public static final String ASYNC_PARAM = "async";
    public static final String FORCE_AWAIT_PARAM = "forceAwait";
    public static final String EXECUTOR_REF_PARAM = "executorRef";
    public static final List<String> METHODS = Arrays.asList("GET", "HEAD", "POST", "PUT", "DELETE", "TRACE", "OPTIONS", "CONNECT", "PATCH");
    private static final long serialVersionUID = -7061982839117697829L;
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private String servletName;
    private boolean async;
    private boolean forceAwait;
    private String executorRef;
    private final ConcurrentMap<CamelContext, ExecutorService> executorServicePerContext = new ConcurrentHashMap<CamelContext, ExecutorService>();
    private ServletResolveConsumerStrategy servletResolveConsumerStrategy = new HttpServletResolveConsumerStrategy();
    private final ConcurrentMap<String, HttpConsumer> consumers = new ConcurrentHashMap<String, HttpConsumer>();

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.servletName = config.getServletName();
        String asyncParam = config.getInitParameter(ASYNC_PARAM);
        this.async = asyncParam != null && ObjectHelper.toBoolean(asyncParam) != false;
        this.forceAwait = Boolean.parseBoolean(config.getInitParameter(FORCE_AWAIT_PARAM));
        this.executorRef = config.getInitParameter(EXECUTOR_REF_PARAM);
        this.log.trace("servlet '{}' initialized with: async={}", (Object)this.servletName, (Object)this.async);
    }

    @Override
    protected void service(HttpServletRequest request, HttpServletResponse response) {
        block2: {
            this.log.trace("Service: {}", (Object)request);
            try {
                this.handleService(request, response);
            }
            catch (Exception e) {
                this.log.warn("Error handling request due to: {}", (Object)e.getMessage(), (Object)e);
                if (response.isCommitted()) break block2;
                CamelServlet.sendError(response, 500);
            }
        }
    }

    protected void handleService(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (this.isAsync()) {
            this.handleAsync(req, resp);
        } else {
            this.doService(req, resp);
        }
    }

    private void handleAsync(HttpServletRequest req, HttpServletResponse resp) throws Exception {
        if (this.executorRef != null) {
            HttpConsumer consumer = this.doResolve(req, resp);
            if (consumer == null) {
                return;
            }
            Executor pool = ObjectHelper.notNull(this.getExecutorService(consumer), this.executorRef);
            AsyncContext context = req.startAsync();
            try {
                pool.execute(() -> this.doAsyncExecution(req, resp, consumer, context));
            }
            catch (RuntimeException re) {
                context.complete();
                throw re;
            }
        }
        AsyncContext context = req.startAsync();
        try {
            context.start(() -> this.doServiceAsync(context));
        }
        catch (RuntimeException re) {
            context.complete();
            throw re;
        }
    }

    private void doAsyncExecution(HttpServletRequest req, HttpServletResponse resp, HttpConsumer consumer, AsyncContext context) {
        try {
            CompletionStage<?> promise = this.doExecute(req, resp, consumer);
            if (promise == null) {
                context.complete();
            } else {
                promise.whenComplete((r, e) -> context.complete());
            }
        }
        catch (Exception e2) {
            this.onError(resp, e2);
            context.complete();
        }
    }

    private void onError(HttpServletResponse resp, Exception e) {
        this.log.error("Error processing request", (Throwable)e);
        CamelServlet.sendError(resp, 500);
        throw new RuntimeCamelException(e);
    }

    protected Executor getExecutorService(HttpConsumer consumer) {
        CamelContext camelContext = consumer.getEndpoint().getCamelContext();
        Executor pool = camelContext.getRegistry().lookupByNameAndType(this.executorRef, Executor.class);
        if (pool != null) {
            return pool;
        }
        if (camelContext.isStopping() || camelContext.isStopped()) {
            return null;
        }
        return this.executorServicePerContext.computeIfAbsent(camelContext, ctx -> this.createExecutorService((CamelContext)ctx, camelContext));
    }

    private ExecutorService createExecutorService(CamelContext ctx, CamelContext camelContext) {
        ExecutorServiceManager manager = camelContext.getExecutorServiceManager();
        ExecutorService es = manager.newThreadPool((Object)this, this.getClass().getSimpleName() + "Executor", this.executorRef);
        if (es == null) {
            this.getServletContext().log("ExecutorServiceRef " + this.executorRef + " not found in registry (as an ExecutorService instance) or as a thread pool profile, will default for " + ctx.getName() + ".");
            es = manager.newDefaultThreadPool(this, this.getClass().getSimpleName() + "Executor");
        }
        ctx.addLifecycleStrategy(this.createLifecycleStrategy());
        return es;
    }

    private LifecycleStrategySupport createLifecycleStrategy() {
        return new LifecycleStrategySupport(){

            @Override
            public void onContextStopping(CamelContext context) {
                ExecutorService service = (ExecutorService)CamelServlet.this.executorServicePerContext.remove(context);
                if (service != null && !service.isShutdown() && !service.isTerminated()) {
                    service.shutdownNow();
                    try {
                        service.awaitTermination(1L, TimeUnit.MINUTES);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doServiceAsync(AsyncContext context) {
        HttpServletRequest request = (HttpServletRequest)context.getRequest();
        HttpServletResponse response = (HttpServletResponse)context.getResponse();
        try {
            this.doService(request, response);
        }
        catch (Exception e) {
            this.onError(response, e);
        }
        finally {
            context.complete();
        }
    }

    protected void doService(HttpServletRequest request, HttpServletResponse response) throws Exception {
        this.log.trace("Service: {}", (Object)request);
        HttpConsumer consumer = this.doResolve(request, response);
        if (consumer != null) {
            this.doExecute(request, response, consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CompletionStage<?> doExecute(HttpServletRequest req, HttpServletResponse res, HttpConsumer consumer) throws Exception {
        if (consumer.isSuspended()) {
            this.log.debug("Consumer suspended, cannot service request {}", (Object)req);
            CamelServlet.sendError(res, 503);
            return null;
        }
        if ("OPTIONS".equals(req.getMethod()) && !consumer.isOptionsEnabled()) {
            this.performOptionsRequest(req, res, consumer);
            return null;
        }
        if (consumer.getEndpoint().getHttpMethodRestrict() != null && !consumer.getEndpoint().getHttpMethodRestrict().contains(req.getMethod())) {
            CamelServlet.sendError(res, 405);
            return null;
        }
        if ("TRACE".equals(req.getMethod()) && !consumer.isTraceEnabled()) {
            CamelServlet.sendError(res, 405);
            return null;
        }
        Exchange exchange = consumer.createExchange(false);
        exchange.setPattern(ExchangePattern.InOut);
        if (consumer.getEndpoint().isBridgeEndpoint()) {
            exchange.setProperty("CamelSkipGzipEncoding", (Object)Boolean.TRUE);
            exchange.setProperty("CamelSkipWwwFormUrlEncoding", (Object)Boolean.TRUE);
        }
        if (consumer.getEndpoint().isDisableStreamCache()) {
            exchange.setProperty("CamelDisableHttpStreamCache", (Object)Boolean.TRUE);
        }
        ClassLoader oldTccl = this.overrideTccl(exchange);
        HttpHelper.setCharsetFromContentType(req.getContentType(), exchange);
        exchange.setIn(new HttpMessage(exchange, consumer.getEndpoint(), req, res));
        String contextPath = consumer.getEndpoint().getPath();
        exchange.getIn().setHeader("CamelServletContextPath", contextPath);
        String httpPath = (String)exchange.getIn().getHeader("CamelHttpPath");
        if (contextPath != null && httpPath.startsWith(contextPath)) {
            exchange.getIn().setHeader("CamelHttpPath", httpPath.substring(contextPath.length()));
        }
        try {
            consumer.createUoW(exchange);
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        boolean isAsync = false;
        CompletionStage<?> result = null;
        try {
            if (this.log.isTraceEnabled()) {
                this.log.trace("Processing request for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            Processor processor = consumer.getProcessor();
            boolean bl = isAsync = this.isAsync() && !this.forceAwait && AsyncProcessor.class.isInstance(processor);
            if (isAsync) {
                result = this.tryAsyncProcess(res, consumer, processor, exchange);
            } else {
                processor.process(exchange);
            }
        }
        catch (Exception e) {
            exchange.setException(e);
        }
        try {
            if (!isAsync) {
                this.afterProcess(res, consumer, exchange, true);
            }
        }
        finally {
            this.restoreTccl(exchange, oldTccl);
        }
        return result;
    }

    private CompletionStage<?> tryAsyncProcess(HttpServletResponse res, HttpConsumer consumer, Processor processor, Exchange exchange) {
        CompletionStage result = ((AsyncProcessor)AsyncProcessor.class.cast(processor)).processAsync(exchange).whenComplete((r, ex) -> {
            if (ex != null) {
                exchange.setException((Throwable)ex);
            } else {
                try {
                    this.afterProcess(res, consumer, exchange, false);
                }
                catch (Exception e) {
                    exchange.setException(e);
                }
            }
        });
        return result;
    }

    private void performOptionsRequest(HttpServletRequest req, HttpServletResponse res, HttpConsumer consumer) {
        Object allowedMethods = METHODS.stream().filter(m -> this.getServletResolveConsumerStrategy().isHttpMethodAllowed(req, (String)m, this.getConsumers())).collect(Collectors.joining(","));
        if (allowedMethods == null && consumer.getEndpoint().getHttpMethodRestrict() != null) {
            allowedMethods = consumer.getEndpoint().getHttpMethodRestrict();
        }
        if (allowedMethods == null) {
            allowedMethods = "GET,HEAD,POST,PUT,DELETE,TRACE,OPTIONS,CONNECT,PATCH";
        }
        if (!((String)allowedMethods).contains("OPTIONS")) {
            allowedMethods = (String)allowedMethods + ",OPTIONS";
        }
        res.addHeader("Allow", (String)allowedMethods);
        res.setStatus(200);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void afterProcess(HttpServletResponse res, HttpConsumer consumer, Exchange exchange, boolean rethrow) throws Exception {
        try {
            Integer bs;
            if (this.log.isTraceEnabled()) {
                this.log.trace("Writing res for exchangeId: {}", (Object)exchange.getExchangeId());
            }
            if ((bs = consumer.getEndpoint().getResponseBufferSize()) != null) {
                this.log.trace("Using res buffer size: {}", (Object)bs);
                res.setBufferSize(bs);
            }
            consumer.getBinding().writeResponse(exchange, res);
        }
        catch (IOException e) {
            this.handleIOException(exchange, rethrow, e);
        }
        catch (Exception e) {
            this.handleException(exchange, rethrow, e);
        }
        finally {
            consumer.doneUoW(exchange);
            consumer.releaseExchange(exchange, false);
        }
    }

    private void handleException(Exchange exchange, boolean rethrow, Exception e) {
        this.log.error("Error processing request", (Throwable)e);
        if (rethrow) {
            throw new RuntimeCamelException(e);
        }
        exchange.setException(e);
    }

    private void handleIOException(Exchange exchange, boolean rethrow, IOException e) throws IOException {
        this.log.error("Error processing request", (Throwable)e);
        if (rethrow) {
            throw e;
        }
        exchange.setException(e);
    }

    private HttpConsumer doResolve(HttpServletRequest request, HttpServletResponse response) {
        HttpConsumer consumer = this.getServletResolveConsumerStrategy().resolve(request, this.getConsumers());
        if (consumer == null) {
            boolean hasAnyMethod = METHODS.stream().anyMatch(m -> this.getServletResolveConsumerStrategy().isHttpMethodAllowed(request, (String)m, this.getConsumers()));
            if (hasAnyMethod) {
                this.log.debug("No consumer to service request {} as method {} is not allowed", (Object)request, (Object)request.getMethod());
                CamelServlet.sendError(response, 405);
                return null;
            }
            this.log.debug("No consumer to service request {} as resource is not found", (Object)request);
            CamelServlet.sendError(response, 404);
            return null;
        }
        return consumer;
    }

    @Override
    public void connect(HttpConsumer consumer) {
        this.log.debug("Connecting consumer: {}", (Object)consumer);
        String endpointUri = consumer.getEndpoint().getEndpointUri();
        if (this.consumers.containsKey(endpointUri)) {
            throw new IllegalStateException("Duplicate request path for " + endpointUri);
        }
        this.consumers.put(endpointUri, consumer);
        RestConsumerContextPathMatcher.register(consumer.getPath());
    }

    @Override
    public void disconnect(HttpConsumer consumer) {
        this.log.debug("Disconnecting consumer: {}", (Object)consumer);
        this.consumers.remove(consumer.getEndpoint().getEndpointUri());
        RestConsumerContextPathMatcher.unRegister(consumer.getPath());
    }

    @Override
    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public ServletResolveConsumerStrategy getServletResolveConsumerStrategy() {
        return this.servletResolveConsumerStrategy;
    }

    public void setServletResolveConsumerStrategy(ServletResolveConsumerStrategy servletResolveConsumerStrategy) {
        this.servletResolveConsumerStrategy = servletResolveConsumerStrategy;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public Map<String, HttpConsumer> getConsumers() {
        return Collections.unmodifiableMap(this.consumers);
    }

    protected static void sendError(HttpServletResponse res, int code) {
        try {
            res.sendError(code);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected ClassLoader overrideTccl(Exchange exchange) {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader appCtxCl = exchange.getContext().getApplicationContextClassLoader();
        if (oldClassLoader == null || appCtxCl == null) {
            return null;
        }
        if (!oldClassLoader.equals(appCtxCl)) {
            Thread.currentThread().setContextClassLoader(appCtxCl);
            if (this.log.isTraceEnabled()) {
                this.log.trace("Overrode TCCL for exchangeId {} to {} on thread {}", new Object[]{exchange.getExchangeId(), appCtxCl, Thread.currentThread().getName()});
            }
            return oldClassLoader;
        }
        return null;
    }

    protected void restoreTccl(Exchange exchange, ClassLoader oldTccl) {
        if (oldTccl == null) {
            return;
        }
        Thread.currentThread().setContextClassLoader(oldTccl);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Restored TCCL for exchangeId {} to {} on thread {}", new Object[]{exchange.getExchangeId(), oldTccl, Thread.currentThread().getName()});
        }
    }
}

