/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProducer;
import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.Producer;
import org.apache.camel.support.AsyncProcessorConverterHelper;
import org.apache.camel.support.DefaultAsyncProducer;
import org.apache.camel.support.EventHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EventNotifierProducer
extends DefaultAsyncProducer {
    private static final Logger LOG = LoggerFactory.getLogger(EventNotifierProducer.class);
    private final AsyncProducer producer;

    public EventNotifierProducer(Producer producer) {
        super(producer.getEndpoint());
        this.producer = AsyncProcessorConverterHelper.convert(producer);
    }

    @Override
    public boolean process(final Exchange exchange, final AsyncCallback callback) {
        if (!this.isStarted()) {
            exchange.setException(new IllegalStateException("Producer has not been started: " + this));
            callback.done(true);
            return true;
        }
        boolean sending = EventHelper.notifyExchangeSending(exchange.getContext(), exchange, this.getEndpoint());
        final StopWatch watch = sending ? new StopWatch() : null;
        try {
            LOG.debug(">>>> {} {}", (Object)this.getEndpoint(), (Object)exchange);
            return this.producer.process(exchange, new AsyncCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void done(boolean doneSync) {
                    try {
                        if (watch != null) {
                            long timeTaken = watch.taken();
                            EventHelper.notifyExchangeSent(exchange.getContext(), exchange, EventNotifierProducer.this.getEndpoint(), timeTaken);
                        }
                    }
                    finally {
                        callback.done(doneSync);
                    }
                }
            });
        }
        catch (Exception throwable) {
            exchange.setException(throwable);
            callback.done(true);
            return true;
        }
    }

    @Override
    public Endpoint getEndpoint() {
        return this.producer.getEndpoint();
    }

    @Override
    public boolean isSingleton() {
        return this.producer.isSingleton();
    }

    @Override
    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.producer);
    }

    @Override
    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.producer);
    }

    @Override
    protected void doStart() throws Exception {
        ServiceHelper.startService(this.producer);
    }

    @Override
    protected void doStop() throws Exception {
        ServiceHelper.stopService(this.producer);
    }
}

