/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.scheduler;

import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.scheduler.SchedulerEndpoint;
import org.apache.camel.health.HealthCheck;
import org.apache.camel.support.ScheduledPollConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchedulerConsumer
extends ScheduledPollConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerConsumer.class);

    public SchedulerConsumer(SchedulerEndpoint endpoint, Processor processor) {
        super(endpoint, processor);
    }

    @Override
    protected HealthCheck.State initialHealthCheckState() {
        return HealthCheck.State.UP;
    }

    @Override
    public SchedulerEndpoint getEndpoint() {
        return (SchedulerEndpoint)super.getEndpoint();
    }

    @Override
    protected int poll() throws Exception {
        return this.sendTimerExchange();
    }

    protected int sendTimerExchange() {
        Exchange exchange = this.createExchange(false);
        if (this.getEndpoint().isIncludeMetadata()) {
            exchange.setProperty("CamelTimerName", (Object)this.getEndpoint().getName());
            Date now = new Date();
            exchange.setProperty("CamelTimerFiredTime", (Object)now);
            exchange.getIn().setHeader("CamelMessageTimestamp", now.getTime());
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Timer {} is firing", (Object)this.getEndpoint().getName());
        }
        if (!this.getEndpoint().isSynchronous()) {
            AtomicBoolean polled = new AtomicBoolean(true);
            boolean doneSync = this.getAsyncProcessor().process(exchange, cbDoneSync -> {
                boolean wasPolled;
                if (exchange.getException() != null) {
                    this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
                }
                if (!(wasPolled = exchange.getProperty("CamelSchedulerPolledMessages", (Object)true, Boolean.TYPE).booleanValue())) {
                    polled.set(false);
                }
                if (!cbDoneSync) {
                    this.releaseExchange(exchange, false);
                }
            });
            if (!doneSync) {
                return polled.get() ? 1 : 0;
            }
        } else {
            try {
                this.getProcessor().process(exchange);
            }
            catch (Exception e) {
                exchange.setException(e);
            }
            if (exchange.getException() != null) {
                this.getExceptionHandler().handleException("Error processing exchange", exchange, exchange.getException());
            }
        }
        boolean polled = exchange.getProperty("CamelSchedulerPolledMessages", (Object)true, Boolean.TYPE);
        this.releaseExchange(exchange, false);
        return polled ? 1 : 0;
    }

    @Override
    protected void doStart() throws Exception {
        this.getEndpoint().onConsumerStart(this);
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        this.getEndpoint().onConsumerStop(this);
        super.doStop();
    }
}

