/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client.spec;

import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.client.ResponseProcessingException;
import jakarta.ws.rs.core.Response;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.cxf.interceptor.AbstractInDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxrs.client.ClientProviderFactory;
import org.apache.cxf.jaxrs.client.spec.ClientRequestContextImpl;
import org.apache.cxf.jaxrs.client.spec.ClientResponseContextImpl;
import org.apache.cxf.jaxrs.impl.ResponseImpl;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;

public class ClientResponseFilterInterceptor
extends AbstractInDatabindingInterceptor {
    public ClientResponseFilterInterceptor() {
        super("pre-protocol-frontend");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessage(Message inMessage) throws Fault {
        ClientProviderFactory pf = ClientProviderFactory.getInstance(inMessage);
        if (pf == null) {
            return;
        }
        List<ProviderInfo<ClientResponseFilter>> filters = pf.getClientResponseFilters();
        if (!filters.isEmpty()) {
            ClientRequestContextImpl reqContext = new ClientRequestContextImpl(inMessage.getExchange().getOutMessage(), true);
            ResponseImpl response = (ResponseImpl)this.getResponse(inMessage);
            ClientResponseContextImpl respContext = new ClientResponseContextImpl(response, inMessage);
            for (ProviderInfo<ClientResponseFilter> filter : filters) {
                InjectionUtils.injectContexts(filter.getProvider(), filter, inMessage);
                try {
                    filter.getProvider().filter(reqContext, respContext);
                }
                catch (IOException | RuntimeException ex) {
                    if (!inMessage.getExchange().isOneWay()) {
                        Exchange exchange = inMessage.getExchange();
                        synchronized (exchange) {
                            inMessage.getExchange().put("IN_CHAIN_COMPLETE", Boolean.TRUE);
                        }
                    }
                    throw new ResponseProcessingException((Response)response, (Throwable)ex);
                }
            }
        }
    }

    protected Response getResponse(Message inMessage) {
        Response resp = inMessage.getExchange().get(Response.class);
        if (resp != null) {
            return JAXRSUtils.copyResponseIfNeeded(resp);
        }
        Integer responseCode = (Integer)inMessage.get(Message.RESPONSE_CODE);
        Response.ResponseBuilder rb = JAXRSUtils.toResponseBuilder(responseCode == null ? 200 : responseCode);
        rb.entity(inMessage.get(InputStream.class));
        Map protocolHeaders = (Map)inMessage.get(Message.PROTOCOL_HEADERS);
        for (Map.Entry entry : protocolHeaders.entrySet()) {
            if (null == entry.getKey() || ((List)entry.getValue()).size() <= 0) continue;
            for (String val : (List)entry.getValue()) {
                rb.header((String)entry.getKey(), val);
            }
        }
        return rb.build();
    }
}

