/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider.json;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.MessageBodyWriter;
import jakarta.ws.rs.ext.Providers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.provider.AbstractConfigurableProvider;
import org.apache.cxf.jaxrs.provider.PrimitiveTextProvider;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class SimpleTypeJsonProvider<T>
extends AbstractConfigurableProvider
implements MessageBodyWriter<T>,
MessageBodyReader<T> {
    @Context
    private Providers providers;
    private boolean supportSimpleTypesOnly;
    private PrimitiveTextProvider<T> primitiveHelper = new PrimitiveTextProvider();

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return !this.supportSimpleTypesOnly || this.primitiveHelper.isReadable(type, genericType, annotations, mediaType);
    }

    @Override
    public long getSize(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeTo(T t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> headers, OutputStream os) throws IOException, WebApplicationException {
        if (!this.supportSimpleTypesOnly && !InjectionUtils.isPrimitive(type)) {
            MessageBodyWriter<?> next = this.providers.getMessageBodyWriter(type, genericType, annotations, mediaType);
            JAXRSUtils.getCurrentMessage().put("active.jaxrs.provider", this);
            try {
                next.writeTo(t, type, genericType, annotations, mediaType, headers, os);
            }
            finally {
                JAXRSUtils.getCurrentMessage().put("active.jaxrs.provider", null);
            }
        } else {
            os.write(StringUtils.toBytesASCII("{\"" + type.getSimpleName().toLowerCase() + "\":"));
            this.writeQuote(os, type);
            this.primitiveHelper.writeTo(t, type, genericType, annotations, mediaType, headers, os);
            this.writeQuote(os, type);
            os.write(StringUtils.toBytesASCII("}"));
        }
    }

    private void writeQuote(OutputStream os, Class<?> type) throws IOException {
        if (type == String.class) {
            os.write(StringUtils.toBytesASCII("\""));
        }
    }

    public void setSupportSimpleTypesOnly(boolean supportSimpleTypesOnly) {
        this.supportSimpleTypesOnly = supportSimpleTypesOnly;
    }

    @Override
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWriteable(type, genericType, annotations, mediaType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T readFrom(Class<T> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream is) throws IOException, WebApplicationException {
        if (!this.supportSimpleTypesOnly && !InjectionUtils.isPrimitive(type)) {
            MessageBodyReader<T> next = this.providers.getMessageBodyReader(type, genericType, annotations, mediaType);
            JAXRSUtils.getCurrentMessage().put("active.jaxrs.provider", this);
            try {
                T t = next.readFrom(type, genericType, annotations, mediaType, headers, is);
                return t;
            }
            finally {
                JAXRSUtils.getCurrentMessage().put("active.jaxrs.provider", null);
            }
        }
        String data = IOUtils.toString(is).trim();
        int index = data.indexOf(58);
        if ((data = data.substring(index + 1, data.length() - 1).trim()).startsWith("\"")) {
            data = data.substring(1, data.length() - 1);
        }
        return this.primitiveHelper.readFrom(type, genericType, annotations, mediaType, headers, new ByteArrayInputStream(StringUtils.toBytesUTF8(data)));
    }
}

