/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientResponseContext;
import jakarta.ws.rs.client.ClientResponseFilter;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.jaxrs.utils.HttpUtils;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsJsonReaderProvider;
import org.apache.cxf.rs.security.jose.jws.JwsJsonConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsJsonSignatureEntry;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;

@Priority(value=1001)
public class JwsJsonClientResponseFilter
extends AbstractJwsJsonReaderProvider
implements ClientResponseFilter {
    @Override
    public void filter(ClientRequestContext req, ClientResponseContext res) throws IOException {
        if (this.isMethodWithNoContent(req.getMethod()) || this.isStatusCodeWithNoContent(res.getStatus()) || this.isCheckEmptyStream() && !res.hasEntity()) {
            return;
        }
        String content = IOUtils.readStringFromStream(res.getEntityStream());
        if (StringUtils.isEmpty(content)) {
            return;
        }
        JwsSignatureVerifier theSigVerifier = this.getInitializedSigVerifier();
        JwsJsonConsumer c = new JwsJsonConsumer(content);
        this.validate(c, theSigVerifier);
        byte[] bytes = c.getDecodedJwsPayloadBytes();
        res.setEntityStream(new ByteArrayInputStream(bytes));
        res.getHeaders().putSingle("Content-Length", Integer.toString(bytes.length));
        JwsJsonSignatureEntry sigEntry = c.getSignatureEntries().get(0);
        String ct = JoseUtils.checkContentType(sigEntry.getUnionHeader().getContentType(), this.getDefaultMediaType());
        if (ct != null) {
            res.getHeaders().putSingle("Content-Type", ct);
        }
    }

    protected boolean isMethodWithNoContent(String method) {
        return "DELETE".equals(method) || HttpUtils.isMethodWithNoResponseContent(method);
    }

    protected boolean isStatusCodeWithNoContent(int statusCode) {
        return statusCode == Response.Status.NO_CONTENT.getStatusCode();
    }
}

