/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Properties;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.apache.cxf.jaxrs.ext.multipart.MultipartInputFilter;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.common.KeyManagementUtils;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsInputStream;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jws.JwsVerificationSignature;

public class JwsMultipartSignatureInFilter
implements MultipartInputFilter {
    private JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();
    private JwsSignatureVerifier verifier;
    private boolean bufferPayload;
    private Message message;
    private boolean useJwsJsonSignatureFormat;

    public JwsMultipartSignatureInFilter(Message message, JwsSignatureVerifier verifier, boolean bufferPayload, boolean useJwsJsonSignatureFormat) {
        this.message = message;
        this.verifier = verifier;
        this.bufferPayload = bufferPayload;
        this.useJwsJsonSignatureFormat = useJwsJsonSignatureFormat;
    }

    @Override
    public void filter(List<Attachment> atts) {
        JwsSignatureVerifier theVerifier;
        Object base64UrlEncodedSignature;
        Object base64UrlEncodedHeaders;
        String jwsSequence;
        if (atts.size() < 2) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        Attachment sigPart = atts.remove(atts.size() - 1);
        try {
            jwsSequence = IOUtils.readStringFromStream(sigPart.getDataHandler().getInputStream());
        }
        catch (IOException ex) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (!this.useJwsJsonSignatureFormat) {
            parts = JoseUtils.getCompactParts(jwsSequence);
            if (((String[])parts).length != 3 || !((String)parts[1]).isEmpty()) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
            base64UrlEncodedHeaders = parts[0];
            base64UrlEncodedSignature = parts[2];
        } else {
            parts = this.reader.fromJson(jwsSequence);
            if (parts.size() != 2 || !parts.containsKey("protected") || !parts.containsKey("signature")) {
                throw ExceptionUtils.toBadRequestException(null, null);
            }
            base64UrlEncodedHeaders = (String)parts.get("protected");
            base64UrlEncodedSignature = (String)parts.get("signature");
        }
        JwsHeaders headers = new JwsHeaders(new JsonMapObjectReaderWriter().fromJson(JoseUtils.decodeToString((String)base64UrlEncodedHeaders)));
        JoseUtils.traceHeaders(headers);
        if (Boolean.FALSE != headers.getPayloadEncodingStatus()) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        if (this.verifier == null) {
            Properties props = KeyManagementUtils.loadStoreProperties(this.message, true, "rs.security.signature.in.properties", "rs.security.signature.properties");
            theVerifier = JwsUtils.loadSignatureVerifier(this.message, props, headers);
        } else {
            theVerifier = this.verifier;
        }
        JwsVerificationSignature sig = theVerifier.createJwsVerificationSignature(headers);
        if (sig == null) {
            throw ExceptionUtils.toBadRequestException(null, null);
        }
        byte[] signatureBytes = JoseUtils.decode((String)base64UrlEncodedSignature);
        byte[] headerBytesWithDot = StringUtils.toBytesASCII((String)base64UrlEncodedHeaders + ".");
        sig.update(headerBytesWithDot, 0, headerBytesWithDot.length);
        int attSize = atts.size();
        for (int i = 0; i < attSize; ++i) {
            InputStream newStream;
            InputStream dataPartStream;
            Attachment dataPart = atts.get(i);
            try {
                dataPartStream = dataPart.getDataHandler().getDataSource().getInputStream();
            }
            catch (IOException ex) {
                throw ExceptionUtils.toBadRequestException(ex, null);
            }
            boolean verifyOnLastRead = i == attSize - 1;
            JwsInputStream jwsStream = new JwsInputStream(dataPartStream, sig, signatureBytes, verifyOnLastRead);
            if (this.bufferPayload) {
                CachedOutputStream cos = new CachedOutputStream();
                try {
                    IOUtils.copy(jwsStream, cos);
                    newStream = cos.getInputStream();
                }
                catch (Exception ex) {
                    throw ExceptionUtils.toBadRequestException(ex, null);
                }
            } else {
                newStream = jwsStream;
            }
            Attachment newDataPart = new Attachment(newStream, dataPart.getHeaders());
            atts.set(i, newDataPart);
        }
    }
}

