/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Mac;
import org.apache.cxf.common.util.Base64Exception;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.rs.security.jose.jwa.AlgorithmUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jws.AbstractJwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rt.security.crypto.HmacUtils;

public class HmacJwsSignatureProvider
extends AbstractJwsSignatureProvider {
    private final byte[] key;
    private final AlgorithmParameterSpec hmacSpec;

    public HmacJwsSignatureProvider(byte[] key, SignatureAlgorithm algo) {
        this(key, null, algo);
    }

    public HmacJwsSignatureProvider(byte[] key, AlgorithmParameterSpec spec, SignatureAlgorithm algo) {
        super(algo);
        this.key = key;
        this.hmacSpec = spec;
    }

    public HmacJwsSignatureProvider(String encodedKey, SignatureAlgorithm algo) {
        super(algo);
        this.hmacSpec = null;
        try {
            this.key = Base64UrlUtility.decode(encodedKey);
        }
        catch (Base64Exception ex) {
            LOG.warning("Hmac key can not be decoded");
            throw new JwsException(JwsException.Error.INVALID_KEY, (Throwable)ex);
        }
    }

    @Override
    protected JwsSignature doCreateJwsSignature(JwsHeaders headers) {
        String sigAlgo = headers.getSignatureAlgorithm().getJwaName();
        final Mac mac = HmacUtils.getInitializedMac(this.key, AlgorithmUtils.toJavaName(sigAlgo), this.hmacSpec);
        return new JwsSignature(){

            @Override
            public void update(byte[] src, int off, int len) {
                mac.update(src, off, len);
            }

            @Override
            public byte[] sign() {
                return mac.doFinal();
            }
        };
    }

    @Override
    protected boolean isValidAlgorithmFamily(String algo) {
        return AlgorithmUtils.isHmacSign(algo);
    }
}

