/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import java.util.Properties;
import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwksService {
    private volatile JsonWebKeys keySet;
    private WebClient keyServiceClient;
    private boolean stripPrivateParameters = true;

    @Path(value="keys")
    @GET
    @Produces(value={"application/json"})
    public JsonWebKeys getPublicVerificationKeys() {
        if (this.keySet == null) {
            this.keySet = this.keyServiceClient == null ? JwksService.getFromLocalStore(this.stripPrivateParameters) : this.keyServiceClient.get(JsonWebKeys.class);
        }
        return this.keySet;
    }

    private static JsonWebKeys getFromLocalStore(boolean stripPrivateParameters) {
        Properties props = JwsUtils.loadSignatureInProperties(true);
        return JwsUtils.loadPublicVerificationKeys(JAXRSUtils.getCurrentMessage(), props, stripPrivateParameters);
    }

    public void setKeyServiceClient(WebClient keyServiceClient) {
        this.keyServiceClient = keyServiceClient;
    }

    public boolean isStripPrivateParameters() {
        return this.stripPrivateParameters;
    }

    public void setStripPrivateParameters(boolean stripPrivateParameters) {
        this.stripPrivateParameters = stripPrivateParameters;
    }
}

