/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.Encoded;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.SecurityContext;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.common.TokenIntrospection;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

@Path(value="introspect")
public class TokenIntrospectionService {
    private static final Logger LOG = LogUtils.getL7dLogger(TokenIntrospectionService.class);
    private boolean blockUnsecureRequests;
    private boolean blockUnauthorizedRequests = true;
    private boolean reportExtraTokenProperties = true;
    private MessageContext mc;
    private OAuthDataProvider dataProvider;
    private JoseJwtConsumer jwtTokenConsumer;
    private boolean persistJwtEncoding = true;

    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/x-www-form-urlencoded"})
    public TokenIntrospection getTokenIntrospection(@Encoded MultivaluedMap<String, String> params) {
        UserSubject userSubject;
        ServerAccessToken at;
        this.checkSecurityContext();
        String tokenId = params.getFirst("token");
        if (!this.persistJwtEncoding) {
            try {
                JoseJwtConsumer theConsumer = this.jwtTokenConsumer == null ? new JoseJwtConsumer() : this.jwtTokenConsumer;
                JwtToken token = theConsumer.getJwtToken(tokenId);
                tokenId = token.getClaims().getTokenId();
            }
            catch (JwtException ex) {
                return new TokenIntrospection(false);
            }
        }
        if ((at = this.dataProvider.getAccessToken(tokenId)) == null || OAuthUtils.isExpired(at.getIssuedAt(), at.getExpiresIn())) {
            return new TokenIntrospection(false);
        }
        TokenIntrospection response = new TokenIntrospection(true);
        response.setClientId(at.getClient().getClientId());
        if (!at.getScopes().isEmpty()) {
            response.setScope(OAuthUtils.convertPermissionsToScope(at.getScopes()));
        }
        if ((userSubject = at.getSubject()) != null) {
            response.setUsername(at.getSubject().getLogin());
            if (userSubject.getId() != null) {
                response.setSub(userSubject.getId());
            }
        }
        if (!StringUtils.isEmpty(at.getAudiences())) {
            response.setAud(at.getAudiences());
        }
        if (at.getIssuer() != null) {
            response.setIss(at.getIssuer());
        }
        response.setIat(at.getIssuedAt());
        if (at.getExpiresIn() > 0L) {
            response.setExp(at.getIssuedAt() + at.getExpiresIn());
        }
        if (at.getNotBefore() > 0L) {
            response.setNbf(at.getNotBefore());
        }
        response.setTokenType(at.getTokenType());
        if (this.reportExtraTokenProperties) {
            response.getExtensions().putAll(at.getExtraProperties());
        }
        return response;
    }

    private void checkSecurityContext() {
        SecurityContext sc = this.mc.getSecurityContext();
        if (!sc.isSecure() && this.blockUnsecureRequests) {
            LOG.warning("Unsecure HTTP, Transport Layer Security is recommended");
            ExceptionUtils.toNotAuthorizedException(null, null);
        }
        if (sc.getUserPrincipal() == null && this.blockUnauthorizedRequests) {
            LOG.warning("Authenticated Principal is not available");
            ExceptionUtils.toNotAuthorizedException(null, null);
        }
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }

    public void setBlockUnauthorizedRequests(boolean blockUnauthorizedRequests) {
        this.blockUnauthorizedRequests = blockUnauthorizedRequests;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public void setReportExtraTokenProperties(boolean reportExtraTokenProperties) {
        this.reportExtraTokenProperties = reportExtraTokenProperties;
    }

    public JoseJwtConsumer getJwtTokenConsumer() {
        return this.jwtTokenConsumer;
    }

    public void setJwtTokenConsumer(JoseJwtConsumer jwtTokenConsumer) {
        this.jwtTokenConsumer = jwtTokenConsumer;
    }

    public boolean isPersistJwtEncoding() {
        return this.persistJwtEncoding;
    }

    public void setPersistJwtEncoding(boolean persistJwtEncoding) {
        this.persistJwtEncoding = persistJwtEncoding;
    }
}

