/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.common.util.Base64UrlOutputStream;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.jose.common.JoseHeaders;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jaxrs.AbstractJwsWriterProvider;
import org.apache.cxf.rs.security.jose.jaxrs.JoseJaxrsUtils;
import org.apache.cxf.rs.security.jose.jws.JwsCompactProducer;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsOutputStream;
import org.apache.cxf.rs.security.jose.jws.JwsSignature;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;

@Priority(value=1002)
public class JwsWriterInterceptor
extends AbstractJwsWriterProvider
implements WriterInterceptor {
    private static final Set<String> DEFAULT_PROTECTED_HTTP_HEADERS = new HashSet<String>(Arrays.asList("Content-Type", "Accept"));
    private Set<String> protectedHttpHeaders = DEFAULT_PROTECTED_HTTP_HEADERS;
    private boolean protectHttpHeaders;
    private boolean contentTypeRequired = true;
    private boolean useJwsOutputStream;
    private boolean encodePayload = true;
    private JsonMapObjectReaderWriter writer = new JsonMapObjectReaderWriter();

    @Override
    public void aroundWriteTo(WriterInterceptorContext ctx) throws IOException, WebApplicationException {
        if (ctx.getEntity() == null) {
            ctx.proceed();
            return;
        }
        JwsHeaders headers = new JwsHeaders();
        JwsSignatureProvider sigProvider = this.getInitializedSigProvider(headers);
        this.setContentTypeIfNeeded(headers, ctx);
        if (!this.encodePayload) {
            headers.setPayloadEncodingStatus(false);
        }
        this.protectHttpHeadersIfNeeded(ctx, headers);
        OutputStream actualOs = ctx.getOutputStream();
        if (this.useJwsOutputStream) {
            JwsSignature jwsSignature = sigProvider.createJwsSignature(headers);
            JoseUtils.traceHeaders(headers);
            JwsOutputStream jwsStream = new JwsOutputStream(actualOs, jwsSignature, true);
            byte[] headerBytes = StringUtils.toBytesUTF8(this.writer.toJson(headers));
            Base64UrlUtility.encodeAndStream(headerBytes, 0, headerBytes.length, jwsStream);
            jwsStream.write(new byte[]{46});
            Base64UrlOutputStream base64Stream = null;
            if (this.encodePayload) {
                base64Stream = new Base64UrlOutputStream(jwsStream);
                ctx.setOutputStream(base64Stream);
            } else {
                ctx.setOutputStream(jwsStream);
            }
            ctx.proceed();
            this.setJoseMediaType(ctx);
            if (base64Stream != null) {
                base64Stream.flush();
            }
            jwsStream.flush();
        } else {
            CachedOutputStream cos = new CachedOutputStream();
            ctx.setOutputStream(cos);
            ctx.proceed();
            JwsCompactProducer p = new JwsCompactProducer(headers, new String(cos.getBytes(), StandardCharsets.UTF_8));
            this.setJoseMediaType(ctx);
            this.writeJws(p, sigProvider, actualOs);
        }
    }

    public void setContentTypeRequired(boolean contentTypeRequired) {
        this.contentTypeRequired = contentTypeRequired;
    }

    public void setUseJwsOutputStream(boolean useJwsOutputStream) {
        this.useJwsOutputStream = useJwsOutputStream;
    }

    private void setContentTypeIfNeeded(JoseHeaders headers, WriterInterceptorContext ctx) {
        MediaType mt;
        if (this.contentTypeRequired && (mt = ctx.getMediaType()) != null && !JAXRSUtils.mediaTypeToString(mt, new String[0]).equals("application/jose")) {
            if ("application".equals(mt.getType())) {
                headers.setContentType(mt.getSubtype());
            } else {
                headers.setContentType(JAXRSUtils.mediaTypeToString(mt, new String[0]));
            }
        }
    }

    private void setJoseMediaType(WriterInterceptorContext ctx) {
        MediaType joseMediaType = JAXRSUtils.toMediaType("application/jose");
        ctx.setMediaType(joseMediaType);
    }

    public void setEncodePayload(boolean encodePayload) {
        this.encodePayload = encodePayload;
    }

    protected void protectHttpHeadersIfNeeded(WriterInterceptorContext ctx, JwsHeaders jwsHeaders) {
        if (this.protectHttpHeaders) {
            JoseJaxrsUtils.protectHttpHeaders(ctx.getHeaders(), jwsHeaders, this.protectedHttpHeaders);
        }
    }

    public void setProtectHttpHeaders(boolean protectHttpHeaders) {
        this.protectHttpHeaders = protectHttpHeaders;
    }

    public void setProtectedHttpHeaders(Set<String> protectedHttpHeaders) {
        this.protectedHttpHeaders = protectedHttpHeaders;
    }
}

