/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jaxrs;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import org.apache.cxf.common.util.Base64UrlUtility;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.rs.security.jose.common.JoseException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rt.security.crypto.CryptoUtils;

@Priority(value=1000)
public class JwtAuthenticationClientFilter
extends JoseJwtProducer
implements ClientRequestFilter {
    private static final String DEFAULT_AUTH_SCHEME = "Bearer";
    private String authScheme = "Bearer";

    @Override
    public void filter(ClientRequestContext requestContext) throws IOException {
        AuthorizationPolicy ap;
        JwtToken jwt = this.getJwtToken(requestContext);
        if (jwt == null && super.isJweRequired() && (ap = JAXRSUtils.getCurrentMessage().getExchange().getEndpoint().getEndpointInfo().getExtensor(AuthorizationPolicy.class)) != null && ap.getUserName() != null) {
            JwtClaims claims = new JwtClaims();
            claims.setSubject(ap.getUserName());
            claims.setClaim("password", ap.getPassword());
            claims.setIssuedAt(System.currentTimeMillis() / 1000L);
            jwt = new JwtToken(new JweHeaders(), claims);
        }
        if (jwt == null) {
            throw new JoseException("JWT token is not available");
        }
        String data = super.processJwt(jwt);
        requestContext.getHeaders().putSingle("Authorization", this.authScheme + " " + data);
    }

    protected JwtToken getJwtToken(ClientRequestContext requestContext) {
        JwtToken token = (JwtToken)requestContext.getProperty("jwt.token");
        if (token == null) {
            Message m = PhaseInterceptorChain.getCurrentMessage();
            token = (JwtToken)m.getContextualProperty("jwt.token");
        }
        if (token != null) {
            return token;
        }
        JwtClaims claims = (JwtClaims)requestContext.getProperty("jwt.claims");
        if (claims == null) {
            Message m = PhaseInterceptorChain.getCurrentMessage();
            claims = (JwtClaims)m.getContextualProperty("jwt.claims");
        }
        if (claims != null) {
            token = new JwtToken(claims);
        }
        return token;
    }

    protected String getContextPropertyValue() {
        return Base64UrlUtility.encode(CryptoUtils.generateSecureRandomBytes(16));
    }

    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }
}

