/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jws;

import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsException;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;

public class JwsCompactConsumer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JwsCompactConsumer.class);
    private JsonMapObjectReaderWriter reader;
    private final String encodedSequence;
    private final String encodedSignature;
    private final String headersJson;
    private String jwsPayload;
    private String decodedJwsPayload;
    private JwsHeaders jwsHeaders;

    public JwsCompactConsumer(String encodedJws) {
        this(encodedJws, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    public JwsCompactConsumer(String encodedJws, String detachedPayload) {
        String[] parts;
        block5: {
            this.reader = new JsonMapObjectReaderWriter();
            parts = JoseUtils.getCompactParts(encodedJws);
            if (parts.length != 3) {
                if (parts.length == 2 && encodedJws.endsWith(".")) {
                    this.encodedSignature = "";
                    break block5;
                } else {
                    LOG.warning("Compact JWS does not have 3 parts");
                    throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
                }
            }
            this.encodedSignature = parts[2];
        }
        this.jwsPayload = parts[1];
        if (detachedPayload != null) {
            if (!StringUtils.isEmpty(this.jwsPayload)) {
                LOG.warning("Compact JWS includes a payload expected to be detached");
                throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
            }
            this.jwsPayload = detachedPayload;
        }
        this.encodedSequence = parts[0] + "." + this.jwsPayload;
        this.headersJson = JoseUtils.decodeToString(parts[0]);
    }

    public String getUnsignedEncodedSequence() {
        return this.encodedSequence;
    }

    public String getEncodedSignature() {
        return this.encodedSignature;
    }

    public String getDecodedJsonHeaders() {
        return this.headersJson;
    }

    public String getDecodedJwsPayload() {
        if (this.decodedJwsPayload == null) {
            this.getJwsHeaders();
            this.decodedJwsPayload = JwsUtils.isPayloadUnencoded(this.jwsHeaders) ? this.jwsPayload : JoseUtils.decodeToString(this.jwsPayload);
        }
        return this.decodedJwsPayload;
    }

    public byte[] getDecodedJwsPayloadBytes() {
        return StringUtils.toBytesUTF8(this.getDecodedJwsPayload());
    }

    public byte[] getDecodedSignature() {
        return this.encodedSignature.isEmpty() ? new byte[]{} : JoseUtils.decode(this.encodedSignature);
    }

    public JwsHeaders getJwsHeaders() {
        if (this.jwsHeaders == null) {
            JsonMapObject joseHeaders = this.reader.fromJsonToJsonObject(this.headersJson);
            if (joseHeaders.getUpdateCount() != null) {
                LOG.warning("Duplicate headers have been detected");
                throw new JwsException(JwsException.Error.INVALID_COMPACT_JWS);
            }
            this.jwsHeaders = new JwsHeaders(joseHeaders.asMap());
        }
        return this.jwsHeaders;
    }

    public boolean verifySignatureWith(JwsSignatureVerifier validator) {
        try {
            if (validator.verify(this.getJwsHeaders(), this.getUnsignedEncodedSequence(), this.getDecodedSignature())) {
                return true;
            }
        }
        catch (JwsException jwsException) {
            // empty catch block
        }
        LOG.warning("Invalid Signature");
        return false;
    }

    public boolean verifySignatureWith(JsonWebKey key) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key));
    }

    public boolean verifySignatureWith(JsonWebKey key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getSignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(X509Certificate cert, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getPublicKeySignatureVerifier(cert, algo));
    }

    public boolean verifySignatureWith(PublicKey key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getPublicKeySignatureVerifier(key, algo));
    }

    public boolean verifySignatureWith(byte[] key, SignatureAlgorithm algo) {
        return this.verifySignatureWith(JwsUtils.getHmacSignatureVerifier(key, algo));
    }

    public boolean validateCriticalHeaders() {
        return JwsUtils.validateCriticalHeaders(this.getJwsHeaders());
    }

    protected JsonMapObjectReaderWriter getReader() {
        return this.reader;
    }
}

