/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.services.RedirectionBasedGrantService;

@Path(value="authorize")
public class AuthorizationService {
    private Map<String, RedirectionBasedGrantService> servicesMap = new HashMap<String, RedirectionBasedGrantService>();

    @Context
    public void setMessageContext(MessageContext context) {
        for (RedirectionBasedGrantService service : this.servicesMap.values()) {
            service.setMessageContext(context);
        }
    }

    @GET
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorize(@QueryParam(value="response_type") String responseType) {
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorize();
        }
        return this.reportInvalidResponseType();
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Produces(value={"application/xhtml+xml", "text/html", "application/xml", "application/json"})
    public Response authorizePost(MultivaluedMap<String, String> params) {
        String responseType = params.getFirst("response_type");
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorize();
        }
        return this.reportInvalidResponseType();
    }

    @GET
    @Path(value="/decision")
    public Response authorizeDecision(@QueryParam(value="response_type") String responseType) {
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorizeDecision();
        }
        return this.reportInvalidResponseType();
    }

    @POST
    @Path(value="/decision")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response authorizeDecisionForm(MultivaluedMap<String, String> params) {
        String responseType = params.getFirst("response_type");
        RedirectionBasedGrantService service = this.getService(responseType);
        if (service != null) {
            return service.authorizeDecisionForm(params);
        }
        return this.reportInvalidResponseType();
    }

    private RedirectionBasedGrantService getService(String responseType) {
        return responseType == null ? null : this.servicesMap.get(responseType);
    }

    public void setServices(List<RedirectionBasedGrantService> services) {
        for (RedirectionBasedGrantService service : services) {
            for (String responseType : service.getSupportedResponseTypes()) {
                this.servicesMap.put(responseType, service);
            }
        }
    }

    protected Response reportInvalidResponseType() {
        return JAXRSUtils.toResponseBuilder(400).type("application/json").entity(new OAuthError("unsupported_response_type")).build();
    }
}

