/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.saga;

import java.util.concurrent.CompletableFuture;
import org.apache.camel.AsyncCallback;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.processor.saga.SagaCompletionMode;
import org.apache.camel.processor.saga.SagaProcessor;
import org.apache.camel.saga.CamelSagaCoordinator;
import org.apache.camel.saga.CamelSagaService;
import org.apache.camel.saga.CamelSagaStep;

public class RequiredSagaProcessor
extends SagaProcessor {
    public RequiredSagaProcessor(CamelContext camelContext, Processor childProcessor, CamelSagaService sagaService, SagaCompletionMode completionMode, CamelSagaStep step) {
        super(camelContext, childProcessor, sagaService, completionMode, step);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        this.getCurrentSagaCoordinator(exchange).whenComplete((existingCoordinator, ex) -> this.ifNotException((Throwable)ex, exchange, callback, () -> {
            boolean inheritedCoordinator;
            CompletableFuture<CamelSagaCoordinator> coordinatorFuture;
            if (existingCoordinator != null) {
                coordinatorFuture = CompletableFuture.completedFuture(existingCoordinator);
                inheritedCoordinator = true;
            } else {
                coordinatorFuture = this.sagaService.newSaga(exchange);
                inheritedCoordinator = false;
            }
            coordinatorFuture.whenComplete((coordinator, ex2) -> this.ifNotException((Throwable)ex2, exchange, !inheritedCoordinator, (CamelSagaCoordinator)coordinator, (CamelSagaCoordinator)existingCoordinator, callback, () -> {
                this.setCurrentSagaCoordinator(exchange, (CamelSagaCoordinator)coordinator);
                coordinator.beginStep(exchange, this.step).whenComplete((done, ex3) -> this.ifNotException((Throwable)ex3, exchange, !inheritedCoordinator, (CamelSagaCoordinator)coordinator, (CamelSagaCoordinator)existingCoordinator, callback, () -> super.process(exchange, doneSync -> {
                    if (!inheritedCoordinator) {
                        this.handleSagaCompletion(exchange, (CamelSagaCoordinator)coordinator, null, callback);
                    } else {
                        callback.done(false);
                    }
                })));
            }));
        }));
        return false;
    }
}

