/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.http.common;

import jakarta.servlet.Servlet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.camel.http.common.CamelServlet;
import org.apache.camel.http.common.HttpConsumer;
import org.apache.camel.http.common.HttpRegistry;
import org.apache.camel.http.common.HttpRegistryProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpRegistry
implements HttpRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultHttpRegistry.class);
    private static final Map<String, HttpRegistry> registries = new ConcurrentHashMap<String, HttpRegistry>();
    private final Lock lock = new ReentrantLock();
    private final Set<HttpConsumer> consumers = new HashSet<HttpConsumer>();
    private final Set<HttpRegistryProvider> providers = new HashSet<HttpRegistryProvider>();

    public static HttpRegistry getHttpRegistry(String name) {
        return registries.computeIfAbsent(name, k -> new DefaultHttpRegistry());
    }

    public static void removeHttpRegistry(String name) {
        registries.remove(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(HttpConsumer consumer) {
        this.lock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering consumer for path {} providers present: {}", (Object)consumer.getPath(), (Object)this.providers.size());
            }
            this.consumers.add(consumer);
            for (HttpRegistryProvider provider : this.providers) {
                provider.connect(consumer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregister(HttpConsumer consumer) {
        this.lock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistering consumer for path {}", (Object)consumer.getPath());
            }
            this.consumers.remove(consumer);
            for (HttpRegistryProvider provider : this.providers) {
                provider.disconnect(consumer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void register(CamelServlet provider, Map properties) {
        provider.setServletName((String)properties.get("servlet-name"));
        this.register(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void register(HttpRegistryProvider provider) {
        this.lock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Registering CamelServlet with name {} consumers present: {}", (Object)provider.getServletName(), (Object)this.consumers.size());
            }
            this.providers.add(provider);
            for (HttpConsumer consumer : this.consumers) {
                provider.connect(consumer);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void unregister(HttpRegistryProvider provider) {
        this.lock.lock();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unregistering CamelServlet with name {}", (Object)provider.getServletName());
            }
            this.providers.remove(provider);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpRegistryProvider getCamelServlet(String servletName) {
        this.lock.lock();
        try {
            for (HttpRegistryProvider provider : this.providers) {
                if (!provider.getServletName().equals(servletName)) continue;
                HttpRegistryProvider httpRegistryProvider = provider;
                return httpRegistryProvider;
            }
            Iterator<HttpRegistryProvider> iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServlets(List<Servlet> servlets) {
        this.lock.lock();
        try {
            this.providers.clear();
            for (Servlet servlet : servlets) {
                if (!(servlet instanceof HttpRegistryProvider)) continue;
                HttpRegistryProvider httpRegistryProvider = (HttpRegistryProvider)servlet;
                this.providers.add(httpRegistryProvider);
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

