/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms;

import jakarta.jms.Message;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.SjmsTemplate;
import org.apache.camel.support.PollingConsumerSupport;

public class SjmsPollingConsumer
extends PollingConsumerSupport {
    private final SjmsTemplate template;
    private final SjmsEndpoint jmsEndpoint;

    public SjmsPollingConsumer(SjmsEndpoint endpoint, SjmsTemplate template) {
        super(endpoint);
        this.jmsEndpoint = endpoint;
        this.template = template;
    }

    @Override
    public SjmsEndpoint getEndpoint() {
        return (SjmsEndpoint)super.getEndpoint();
    }

    @Override
    public Exchange receiveNoWait() {
        return this.receive(-1L);
    }

    @Override
    public Exchange receive() {
        return this.receive(0L);
    }

    @Override
    public Exchange receive(long timeout) {
        try {
            Message message = this.template.receive(this.jmsEndpoint.getDestinationName(), this.jmsEndpoint.getMessageSelector(), this.jmsEndpoint.isTopic(), timeout);
            if (message != null) {
                return this.getEndpoint().createExchange(message, null);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException(e);
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
    }

    @Override
    protected void doStop() throws Exception {
    }
}

