/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.camel.component.sjms.jms.DestinationCreationStrategy;
import org.apache.camel.util.URISupport;

public class DefaultDestinationCreationStrategy
implements DestinationCreationStrategy {
    @Override
    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        Topic destination;
        if (topic) {
            name = URISupport.stripPrefix(name, "topic://");
            name = URISupport.stripPrefix(name, "topic:");
            destination = session.createTopic(name);
        } else {
            name = URISupport.stripPrefix(name, "queue://");
            name = URISupport.stripPrefix(name, "queue:");
            destination = session.createQueue(name);
        }
        return destination;
    }

    @Override
    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        if (topic) {
            return session.createTemporaryTopic();
        }
        return session.createTemporaryQueue();
    }
}

