/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sjms2.jms;

import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.Topic;
import org.apache.camel.Endpoint;
import org.apache.camel.component.sjms.SjmsEndpoint;
import org.apache.camel.component.sjms.jms.JmsObjectFactory;
import org.apache.camel.component.sjms2.Sjms2Endpoint;
import org.apache.camel.util.ObjectHelper;

public class Jms2ObjectFactory
implements JmsObjectFactory {
    @Override
    public MessageConsumer createMessageConsumer(Session session, Endpoint endpoint) throws Exception {
        Sjms2Endpoint sjms2Endpoint = (Sjms2Endpoint)endpoint;
        Destination destination = sjms2Endpoint.getDestinationCreationStrategy().createDestination(session, sjms2Endpoint.getDestinationName(), sjms2Endpoint.isTopic());
        return this.createMessageConsumer(session, destination, sjms2Endpoint.getMessageSelector(), sjms2Endpoint.isTopic(), sjms2Endpoint.getSubscriptionId(), sjms2Endpoint.isDurable(), sjms2Endpoint.isShared());
    }

    @Override
    public MessageConsumer createQueueMessageConsumer(Session session, Destination destination) throws Exception {
        return this.createMessageConsumer(session, destination, null, false, null, false, false);
    }

    @Override
    public MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String subscriptionId, boolean durable, boolean shared) throws Exception {
        return this.createMessageConsumer(session, destination, messageSelector, topic, subscriptionId, durable, shared, false);
    }

    @Override
    public MessageConsumer createMessageConsumer(Session session, Destination destination, String messageSelector, boolean topic, String subscriptionId, boolean durable, boolean shared, boolean noLocal) throws Exception {
        if (topic) {
            return this.createTopicMessageConsumer(session, destination, messageSelector, subscriptionId, durable, shared, noLocal);
        }
        return this.createQueueMessageConsumer(session, destination, messageSelector);
    }

    private MessageConsumer createQueueMessageConsumer(Session session, Destination destination, String messageSelector) throws JMSException {
        if (ObjectHelper.isNotEmpty(messageSelector)) {
            return session.createConsumer(destination, messageSelector);
        }
        return session.createConsumer(destination);
    }

    private MessageConsumer createTopicMessageConsumer(Session session, Destination destination, String messageSelector, String subscriptionId, boolean durable, boolean shared, boolean noLocal) throws JMSException {
        if (ObjectHelper.isNotEmpty(subscriptionId)) {
            return this.createSubscriptionTopicConsumer(session, destination, messageSelector, subscriptionId, durable, shared, noLocal);
        }
        return this.createSubscriptionlessTopicConsumer(session, destination, messageSelector, noLocal);
    }

    private MessageConsumer createSubscriptionTopicConsumer(Session session, Destination destination, String messageSelector, String subscriptionId, boolean durable, boolean shared, boolean noLocal) throws JMSException {
        if (shared) {
            if (durable) {
                if (ObjectHelper.isNotEmpty(messageSelector)) {
                    return session.createSharedDurableConsumer((Topic)destination, subscriptionId, messageSelector);
                }
                return session.createSharedDurableConsumer((Topic)destination, subscriptionId);
            }
            if (ObjectHelper.isNotEmpty(messageSelector)) {
                return session.createSharedConsumer((Topic)destination, subscriptionId, messageSelector);
            }
            return session.createSharedConsumer((Topic)destination, subscriptionId);
        }
        if (durable) {
            if (ObjectHelper.isNotEmpty(messageSelector)) {
                return session.createDurableSubscriber((Topic)destination, subscriptionId, messageSelector, noLocal);
            }
            return session.createDurableSubscriber((Topic)destination, subscriptionId);
        }
        return this.createSubscriptionlessTopicConsumer(session, destination, messageSelector, noLocal);
    }

    private MessageConsumer createSubscriptionlessTopicConsumer(Session session, Destination destination, String messageSelector, boolean noLocal) throws JMSException {
        if (ObjectHelper.isNotEmpty(messageSelector)) {
            return session.createConsumer(destination, messageSelector, noLocal);
        }
        return session.createConsumer(destination);
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Endpoint endpoint) throws Exception {
        Sjms2Endpoint sjms2Endpoint = (Sjms2Endpoint)endpoint;
        return this.createMessageProducer(session, endpoint, sjms2Endpoint.getDestinationName());
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Endpoint endpoint, String destinationName) throws Exception {
        Sjms2Endpoint sjms2Endpoint = (Sjms2Endpoint)endpoint;
        Destination destination = sjms2Endpoint.getDestinationCreationStrategy().createDestination(session, destinationName, sjms2Endpoint.isTopic());
        boolean persistent = sjms2Endpoint.isDeliveryPersistent();
        if (sjms2Endpoint.getDeliveryMode() != null) {
            persistent = 2 == sjms2Endpoint.getDeliveryMode();
        }
        return this.createMessageProducer(session, destination, persistent, sjms2Endpoint.getTimeToLive());
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Endpoint endpoint, Destination destination) throws Exception {
        SjmsEndpoint sjmsEndpoint = (SjmsEndpoint)endpoint;
        boolean persistent = sjmsEndpoint.isDeliveryPersistent();
        if (sjmsEndpoint.getDeliveryMode() != null) {
            persistent = 2 == sjmsEndpoint.getDeliveryMode();
        }
        return this.createMessageProducer(session, destination, persistent, sjmsEndpoint.getTimeToLive());
    }

    @Override
    public MessageProducer createMessageProducer(Session session, Destination destination, boolean persistent, long ttl) throws Exception {
        MessageProducer messageProducer = session.createProducer(destination);
        messageProducer.setDeliveryMode(persistent ? 2 : 1);
        if (ttl > 0L) {
            messageProducer.setTimeToLive(ttl);
        }
        return messageProducer;
    }
}

