/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.task.budget;

import java.time.Duration;
import org.apache.camel.support.task.budget.BudgetBuilder;
import org.apache.camel.support.task.budget.IterationBoundedBudget;
import org.apache.camel.support.task.budget.IterationBudget;
import org.apache.camel.support.task.budget.backoff.BackOffStrategy;

public class IterationBoundedBudgetBuilder
implements BudgetBuilder<IterationBudget> {
    private static final int DEFAULT_MAX_ITERATIONS = Integer.MAX_VALUE;
    private static final long DEFAULT_INITIAL_DELAY = 0L;
    private static final long DEFAULT_INTERVAL = 1000L;
    protected long initialDelay = 0L;
    protected long interval = 1000L;
    protected int maxIterations = Integer.MAX_VALUE;
    protected BackOffStrategy backOffStrategy;

    public IterationBoundedBudgetBuilder withInitialDelay(Duration duration) {
        if (duration != null) {
            this.initialDelay = duration.toMillis();
        }
        return this;
    }

    public IterationBoundedBudgetBuilder withInterval(Duration duration) {
        if (duration != null) {
            this.interval = duration.toMillis();
        }
        return this;
    }

    public IterationBoundedBudgetBuilder withMaxIterations(int maxIterations) {
        if (maxIterations > 0) {
            this.maxIterations = maxIterations;
        }
        return this;
    }

    public IterationBoundedBudgetBuilder withUnlimitedMaxIterations() {
        this.maxIterations = Integer.MAX_VALUE;
        return this;
    }

    public IterationBoundedBudgetBuilder withBackOffStrategy(BackOffStrategy backOffStrategy) {
        this.backOffStrategy = backOffStrategy;
        return this;
    }

    @Override
    public IterationBoundedBudget build() {
        if (this.backOffStrategy == null) {
            return new IterationBoundedBudget(this.initialDelay, this.interval, this.maxIterations);
        }
        return new IterationBoundedBudget(this.initialDelay, this.maxIterations, this.backOffStrategy);
    }
}

