/*
 * Decompiled with CFR 0.152.
 */
package com.slack.api.methods;

import com.slack.api.methods.MethodsRateLimitTier;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodsRateLimits {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MethodsRateLimits.class);
    private static final ConcurrentMap<String, MethodsRateLimitTier> methodNameToTier = new ConcurrentHashMap<String, MethodsRateLimitTier>();

    public static MethodsRateLimitTier lookupRateLimitTier(String methodName) {
        if (methodName == null) {
            return null;
        }
        return (MethodsRateLimitTier)((Object)methodNameToTier.get(methodName));
    }

    public TreeMap<String, String> toMap() {
        TreeMap<String, String> result = new TreeMap<String, String>();
        for (Map.Entry e : methodNameToTier.entrySet()) {
            result.put((String)e.getKey(), ((MethodsRateLimitTier)((Object)e.getValue())).name());
        }
        return result;
    }

    public static void setRateLimitTier(String methodName, MethodsRateLimitTier tier) {
        MethodsRateLimitTier currentTier = MethodsRateLimits.lookupRateLimitTier(methodName);
        if (currentTier != null) {
            String skipMessage = "Skipped to set tier for " + methodName + " as it's already set as " + (Object)((Object)currentTier);
            throw new IllegalArgumentException(skipMessage);
        }
        methodNameToTier.putIfAbsent(methodName, tier);
    }

    static {
        List<String> adminApiMethods_Tier1 = Arrays.asList("admin.conversations.restrictAccess.removeGroup", "admin.conversations.whitelist.remove", "admin.teams.create", "admin.usergroups.addChannels", "admin.users.unsupportedVersions.export", "admin.apps.uninstall");
        for (String string : adminApiMethods_Tier1) {
            MethodsRateLimits.setRateLimitTier(string, MethodsRateLimitTier.Tier1);
        }
        List<String> adminApiMethods_Tier2 = Arrays.asList("admin.analytics.getFile", "admin.apps.approve", "admin.apps.clearResolution", "admin.apps.restrict", "admin.apps.approved.list", "admin.apps.restricted.list", "admin.apps.requests.cancel", "admin.apps.requests.list", "admin.apps.config.lookup", "admin.barriers.create", "admin.barriers.delete", "admin.barriers.list", "admin.barriers.update", "admin.conversations.restrictAccess.addGroup", "admin.conversations.restrictAccess.listGroups", "admin.conversations.whitelist.add", "admin.conversations.whitelist.listGroupsLinkedToChannel", "admin.conversations.archive", "admin.conversations.convertToPrivate", "admin.conversations.create", "admin.conversations.delete", "admin.conversations.disconnectShared", "admin.conversations.getConversationPrefs", "admin.conversations.getTeams", "admin.conversations.invite", "admin.conversations.rename", "admin.conversations.search", "admin.conversations.setConversationPrefs", "admin.conversations.setTeams", "admin.conversations.unarchive", "admin.conversations.ekm.listOriginalConnectedChannelInfo", "admin.conversations.getCustomRetention", "admin.conversations.removeCustomRetention", "admin.conversations.setCustomRetention", "admin.conversations.bulkArchive", "admin.conversations.bulkDelete", "admin.conversations.bulkMove", "admin.conversations.convertToPublic", "admin.conversations.lookup", "admin.emoji.add", "admin.emoji.addAlias", "admin.emoji.list", "admin.emoji.remove", "admin.emoji.rename", "admin.inviteRequests.approve", "admin.inviteRequests.deny", "admin.inviteRequests.list", "admin.inviteRequests.approved.list", "admin.inviteRequests.denied.list", "admin.functions.list", "admin.roles.addAssignments", "admin.roles.removeAssignments", "admin.teams.settings.setDefaultChannels", "admin.teams.settings.setDescription", "admin.teams.settings.setDiscoverability", "admin.teams.settings.setIcon", "admin.users.assign", "admin.users.invite", "admin.users.remove", "admin.users.setAdmin", "admin.users.setExpiration", "admin.users.setOwner", "admin.users.setRegular", "admin.users.session.invalidate", "admin.users.session.list", "admin.users.session.reset", "admin.users.session.resetBulk", "admin.usergroups.addTeams", "admin.usergroups.listChannels", "admin.usergroups.removeChannels", "admin.workflows.collaborators.add", "admin.workflows.collaborators.remove", "admin.workflows.permissions.lookup", "admin.workflows.search", "admin.workflows.unpublish");
        for (String string : adminApiMethods_Tier2) {
            MethodsRateLimits.setRateLimitTier(string, MethodsRateLimitTier.Tier2);
        }
        List<String> list = Arrays.asList("admin.roles.listAssignments", "admin.teams.admins.list", "admin.teams.list", "admin.teams.owners.list", "admin.teams.settings.info", "admin.teams.settings.setName", "admin.users.list", "admin.apps.activities.list", "admin.apps.config.set", "admin.functions.permissions.lookup", "admin.functions.permissions.set");
        for (String string : list) {
            MethodsRateLimits.setRateLimitTier(string, MethodsRateLimitTier.Tier3);
        }
        List<String> list2 = Arrays.asList("admin.users.session.getSettings", "admin.users.session.setSettings", "admin.users.session.clearSettings", "admin.auth.policy.assignEntities", "admin.auth.policy.getEntities", "admin.auth.policy.removeEntities");
        for (String methods : list2) {
            MethodsRateLimits.setRateLimitTier(methods, MethodsRateLimitTier.Tier4);
        }
        List<String> list3 = Arrays.asList("apps.permissions.info", "apps.permissions.request", "apps.permissions.resources.list", "apps.permissions.scopes.list", "apps.permissions.users.list", "apps.permissions.users.request");
        for (String methods : list3) {
            MethodsRateLimits.setRateLimitTier(methods, MethodsRateLimitTier.Tier2);
        }
        MethodsRateLimits.setRateLimitTier("apps.manifest.create", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("apps.manifest.delete", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("apps.manifest.export", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("apps.manifest.update", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("apps.manifest.validate", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("tooling.tokens.rotate", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("api.test", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("apps.connections.open", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("apps.uninstall", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("apps.event.authorizations.list", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("auth.revoke", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("auth.test", MethodsRateLimitTier.SpecialTier_auth_test);
        MethodsRateLimits.setRateLimitTier("auth.teams.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("bookmarks.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("bookmarks.edit", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("bookmarks.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("bookmarks.remove", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("bots.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("calls.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("calls.end", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("calls.info", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("calls.update", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("calls.participants.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("calls.participants.remove", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("canvases.access.delete", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("canvases.access.set", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("canvases.create", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("canvases.delete", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("canvases.edit", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("canvases.sections.lookup", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.canvases.create", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("chat.delete", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("chat.deleteScheduledMessage", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("chat.getPermalink", MethodsRateLimitTier.SpecialTier_chat_getPermalink);
        MethodsRateLimits.setRateLimitTier("chat.meMessage", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("chat.postEphemeral", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("chat.postMessage", MethodsRateLimitTier.SpecialTier_chat_postMessage);
        MethodsRateLimits.setRateLimitTier("chat.scheduleMessage", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("chat.unfurl", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("chat.update", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("chat.scheduledMessages.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.archive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.archive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.archive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.close", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("im.close", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("mpim.close", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.create", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.create", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.create", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.history", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.history", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.history", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("im.history", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("mpim.history", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.invite", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.invite", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.invite", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.join", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.join", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.kick", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.kick", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.kick", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.leave", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.leave", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.leave", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("im.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("mpim.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.members", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("conversations.open", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.open", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("im.open", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("mpim.open", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("conversations.rename", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.rename", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.rename", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.replies", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.replies", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.replies", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("im.replies", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("mpim.replies", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.setPurpose", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.setPurpose", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.setPurpose", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.setTopic", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.setTopic", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.setTopic", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.unarchive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("channels.unarchive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("groups.unarchive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.mark", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("channels.mark", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.mark", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("im.mark", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("mpim.mark", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("groups.createChild", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.inviteShared", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("conversations.acceptSharedInvite", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("conversations.approveSharedInvite", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("conversations.declineSharedInvite", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("conversations.listConnectInvites", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("conversations.externalInvitePermissions.set", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("dialog.open", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("dnd.endDnd", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("dnd.endSnooze", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("dnd.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("dnd.setSnooze", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("dnd.teamInfo", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("emoji.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.comments.delete", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.delete", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("files.info", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("files.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("files.revokePublicURL", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("files.sharedPublicURL", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("files.upload", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.getUploadURLExternal", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("files.completeUploadExternal", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("files.remote.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.remote.info", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.remote.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.remote.remove", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.remote.share", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("files.remote.update", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("functions.completeSuccess", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("functions.completeError", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("migration.exchange", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("oauth.access", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("oauth.token", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("oauth.v2.access", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("oauth.v2.exchange", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("openid.connect.token", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("openid.connect.userInfo", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("pins.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("pins.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("pins.remove", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reactions.add", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("reactions.get", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("reactions.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reactions.remove", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reminders.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reminders.complete", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reminders.delete", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reminders.info", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("reminders.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("rtm.connect", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("rtm.start", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("search.all", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("search.files", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("search.messages", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("stars.add", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("stars.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("stars.remove", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("team.accessLogs", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("team.billableInfo", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("team.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("team.integrationLogs", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("team.profile.get", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("team.billing.info", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("team.preferences.list", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("team.externalTeams.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("team.externalTeams.disconnect", MethodsRateLimitTier.Tier1);
        MethodsRateLimits.setRateLimitTier("usergroups.create", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("usergroups.disable", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("usergroups.enable", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("usergroups.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("usergroups.update", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("usergroups.users.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("usergroups.users.update", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.conversations", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.deletePhoto", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.getPresence", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("users.identity", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("users.info", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("users.list", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.lookupByEmail", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("users.setActive", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.setPhoto", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.setPresence", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("users.profile.get", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("users.profile.set", MethodsRateLimitTier.Tier3);
        MethodsRateLimits.setRateLimitTier("users.discoverableContacts.lookup", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("views.open", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("views.publish", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("views.push", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("views.update", MethodsRateLimitTier.Tier4);
        MethodsRateLimits.setRateLimitTier("workflows.stepCompleted", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("workflows.stepFailed", MethodsRateLimitTier.Tier2);
        MethodsRateLimits.setRateLimitTier("workflows.updateStep", MethodsRateLimitTier.Tier2);
    }
}

